/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.algo.PathComputationAlgorithm;
import org.opendaylight.algo.impl.CspfPath;
import org.opendaylight.algo.impl.ShortestPathFirst;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedVertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ConstrainedPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.PathConstraints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.path.descriptions.PathDescription;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.path.descriptions.PathDescriptionBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPathComputation
implements PathComputationAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPathComputation.class);
    protected final ConnectedGraph graph;
    protected CspfPath pathSource = null;
    protected CspfPath pathDestination = null;
    protected PathConstraints constraints = null;
    protected final PriorityQueue<CspfPath> priorityQueue = new PriorityQueue();
    protected final HashMap<Long, CspfPath> processedPath = new HashMap();

    protected AbstractPathComputation(ConnectedGraph graph) {
        this.graph = graph;
    }

    protected ConstrainedPathBuilder initializePathComputation(VertexKey src, VertexKey dst) {
        ConstrainedPathBuilder cpathBuilder = new ConstrainedPathBuilder().setStatus(ComputationStatus.InProgress);
        if (src.equals((Object)dst)) {
            LOG.warn("Source and Destination are equal: Abort!");
            cpathBuilder.setStatus(ComputationStatus.Failed);
            return cpathBuilder;
        }
        ConnectedVertex vertex = this.graph.getConnectedVertex(Long.valueOf(src.getVertexId().longValue()));
        if (vertex == null) {
            LOG.warn("Found no source for Vertex Key {}", (Object)src);
            cpathBuilder.setStatus(ComputationStatus.Failed);
            return cpathBuilder;
        }
        LOG.debug("Create Path Source with Vertex {}", (Object)vertex);
        this.pathSource = new CspfPath(vertex).setCost(0).setDelay(0);
        cpathBuilder.setSource(vertex.getVertex().getVertexId());
        vertex = this.graph.getConnectedVertex(Long.valueOf(dst.getVertexId().longValue()));
        if (vertex == null) {
            LOG.warn("Found no destination for Vertex Key {}", (Object)src);
            cpathBuilder.setStatus(ComputationStatus.Failed);
            return cpathBuilder;
        }
        LOG.debug("Create Path Destination with Vertex {}", (Object)vertex);
        this.pathDestination = new CspfPath(vertex);
        cpathBuilder.setDestination(vertex.getVertex().getVertexId());
        this.priorityQueue.clear();
        this.priorityQueue.add(this.pathSource);
        this.processedPath.clear();
        this.processedPath.put(this.pathSource.getVertexKey(), this.pathSource);
        this.processedPath.put(this.pathDestination.getVertexKey(), this.pathDestination);
        return cpathBuilder;
    }

    protected boolean pruneEdge(ConnectedEdge edge, CspfPath path) {
        EdgeAttributes attributes;
        if (this.constraints == null) {
            LOG.warn("Constraints not set");
            return true;
        }
        if (edge.getDestination() == null || edge.getDestination().getVertex() == null) {
            LOG.debug("No Destination");
            return true;
        }
        EdgeAttributes edgeAttributes = attributes = edge.getEdge() != null ? edge.getEdge().getEdgeAttributes() : null;
        if (attributes == null) {
            LOG.debug("No attributes");
            return true;
        }
        switch (this.constraints.getAddressFamily()) {
            case Ipv4: {
                if (attributes.getRemoteAddress() != null && attributes.getRemoteAddress().getIpv4Address() != null) break;
                LOG.debug("No Ipv4 address");
                return true;
            }
            case Ipv6: {
                if (attributes.getRemoteAddress() != null && attributes.getRemoteAddress().getIpv6Address() != null) break;
                LOG.debug("No Ipv6 address");
                return true;
            }
            case SrIpv4: {
                if (this.getIpv4NodeSid(edge.getDestination()) == null) {
                    LOG.debug("No Node-SID for IPv4");
                    return true;
                }
                if (attributes.getAdjSid() != null) break;
                LOG.debug("No Adjacency-SID");
                return true;
            }
            case SrIpv6: {
                if (this.getIpv6NodeSid(edge.getDestination()) == null) {
                    LOG.debug("No Node-SID for IPv6");
                    return true;
                }
                if (attributes.getAdjSid() != null) break;
                LOG.debug("No SR Adjacency-SID");
                return true;
            }
            default: {
                return true;
            }
        }
        if (this instanceof ShortestPathFirst) {
            LOG.trace("Edge {} is valid for Simple Path Computation", (Object)edge);
            return false;
        }
        if (this.constraints.getTeMetric() != null) {
            if (attributes.getTeMetric() == null) {
                return true;
            }
            int totalCost = attributes.getTeMetric().intValue() + path.getCost();
            if (totalCost > this.constraints.getTeMetric().intValue()) {
                LOG.debug("TeMetric {} exceed constraint {}", (Object)totalCost, (Object)this.constraints.getTeMetric().intValue());
                return true;
            }
        }
        if (this.constraints.getDelay() != null) {
            if (attributes.getDelay() == null) {
                return true;
            }
            int totalDelay = attributes.getDelay().getValue().intValue() + path.getDelay();
            if (totalDelay > this.constraints.getDelay().getValue().intValue()) {
                LOG.debug("Delay {} exceed constraint {}", (Object)totalDelay, (Object)this.constraints.getDelay().getValue().intValue());
                return true;
            }
        }
        if (this.constraints.getLoss() != null && (attributes.getLoss() == null || attributes.getLoss().getValue().intValue() > this.constraints.getLoss().getValue().intValue())) {
            return true;
        }
        if (this.constraints.getBandwidth() != null) {
            if (attributes.getMaxLinkBandwidth() == null || attributes.getMaxResvLinkBandwidth() == null || attributes.getUnreservedBandwidth() == null || attributes.getUnreservedBandwidth().get(this.constraints.getClassType().intValue()) == null) {
                return true;
            }
            Long bandwidth = this.constraints.getBandwidth().getValue().longValue();
            Long unrsv = 0L;
            for (UnreservedBandwidth unResBw : attributes.getUnreservedBandwidth()) {
                if (unResBw.getClassType().intValue() != this.constraints.getClassType().intValue()) continue;
                unrsv = unResBw.getBandwidth().getValue().longValue();
                break;
            }
            if (unrsv < bandwidth || attributes.getMaxLinkBandwidth().getValue().longValue() < bandwidth || attributes.getMaxResvLinkBandwidth().getValue().longValue() < bandwidth) {
                LOG.debug("Bandwidth constraint is not met");
                return true;
            }
        }
        if (this.constraints.getAdminGroup() != null && !this.constraints.getAdminGroup().equals(attributes.getAdminGroup())) {
            LOG.debug("Not in the requested admin-group");
            return true;
        }
        LOG.trace("Edge {} is valid for Constrained Path Computation", (Object)edge);
        return false;
    }

    protected @Nullable MplsLabel getIpv4NodeSid(ConnectedVertex cvertex) {
        if (cvertex.getVertex() == null || cvertex.getVertex().getSrgb() == null) {
            return null;
        }
        if (cvertex.getPrefixes() == null) {
            return null;
        }
        for (Prefix prefix : cvertex.getPrefixes()) {
            if (prefix.getPrefixSid() == null || prefix.getNodeSid() == null || !prefix.getNodeSid().booleanValue() || prefix.getPrefix().getIpv4Prefix() == null) continue;
            return new MplsLabel(Uint32.valueOf((int)prefix.getPrefixSid().intValue()));
        }
        return null;
    }

    protected @Nullable MplsLabel getIpv6NodeSid(ConnectedVertex cvertex) {
        if (cvertex.getVertex() == null || cvertex.getVertex().getSrgb() == null) {
            return null;
        }
        if (cvertex.getPrefixes() == null) {
            return null;
        }
        for (Prefix prefix : cvertex.getPrefixes()) {
            if (prefix.getPrefixSid() == null || prefix.getNodeSid() == null || !prefix.getNodeSid().booleanValue() || prefix.getPrefix().getIpv6Prefix() == null) continue;
            return new MplsLabel(Uint32.valueOf((int)prefix.getPrefixSid().intValue()));
        }
        return null;
    }

    protected List<PathDescription> getPathDescription(List<ConnectedEdge> edges) {
        ArrayList<PathDescription> list = new ArrayList<PathDescription>();
        for (ConnectedEdge edge : edges) {
            PathDescription pathDesc = null;
            switch (this.constraints.getAddressFamily()) {
                case Ipv4: {
                    pathDesc = new PathDescriptionBuilder().setIpv4(edge.getEdge().getEdgeAttributes().getRemoteAddress().getIpv4Address()).build();
                    break;
                }
                case Ipv6: {
                    pathDesc = new PathDescriptionBuilder().setIpv6(edge.getEdge().getEdgeAttributes().getRemoteAddress().getIpv6Address()).build();
                    break;
                }
                case SrIpv4: {
                    pathDesc = new PathDescriptionBuilder().setLocalIpv4(edge.getEdge().getEdgeAttributes().getLocalAddress().getIpv4Address()).setRemoteIpv4(edge.getEdge().getEdgeAttributes().getRemoteAddress().getIpv4Address()).setSid(edge.getEdge().getEdgeAttributes().getAdjSid()).build();
                    break;
                }
                case SrIpv6: {
                    pathDesc = new PathDescriptionBuilder().setLocalIpv6(edge.getEdge().getEdgeAttributes().getLocalAddress().getIpv6Address()).setRemoteIpv6(edge.getEdge().getEdgeAttributes().getRemoteAddress().getIpv6Address()).setSid(edge.getEdge().getEdgeAttributes().getAdjSid()).build();
                    break;
                }
            }
            list.add(pathDesc);
        }
        return list;
    }

    public abstract ConstrainedPath computeP2pPath(VertexKey var1, VertexKey var2, PathConstraints var3);
}

