/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import java.util.HashMap;
import java.util.List;
import org.opendaylight.algo.impl.AbstractPathComputation;
import org.opendaylight.algo.impl.CspfPath;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ConstrainedPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.PathConstraints;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstrainedShortestPathFirst
extends AbstractPathComputation {
    private static final Logger LOG = LoggerFactory.getLogger(ConstrainedShortestPathFirst.class);
    private final HashMap<Long, CspfPath> visitedVertices = new HashMap();

    public ConstrainedShortestPathFirst(ConnectedGraph graph) {
        super(graph);
    }

    @Override
    public ConstrainedPath computeP2pPath(VertexKey src, VertexKey dst, PathConstraints cts) {
        LOG.info("Start CSPF Path Computation from {} to {} with constraints {}", new Object[]{src, dst, cts});
        this.constraints = cts;
        ConstrainedPathBuilder cpathBuilder = this.initializePathComputation(src, dst);
        if (cpathBuilder.getStatus() == ComputationStatus.Failed) {
            return cpathBuilder.build();
        }
        cpathBuilder.setBandwidth(cts.getBandwidth()).setClassType(cts.getClassType());
        this.visitedVertices.clear();
        int currentCost = Integer.MAX_VALUE;
        while (this.priorityQueue.size() != 0) {
            CspfPath currentPath = (CspfPath)this.priorityQueue.poll();
            this.visitedVertices.put(currentPath.getVertexKey(), currentPath);
            LOG.debug("Got path to Vertex {} from Priority Queue", (Object)currentPath.getVertex());
            List edges = currentPath.getVertex().getOutputConnectedEdges();
            for (ConnectedEdge edge : edges) {
                if (this.pruneEdge(edge, currentPath)) {
                    LOG.trace("  Prune Edge {}", (Object)edge);
                    continue;
                }
                if (!this.relaxMultiConstraints(edge, currentPath) || this.pathDestination.getCost() >= currentCost) continue;
                currentCost = this.pathDestination.getCost();
                cpathBuilder.setPathDescription(this.getPathDescription(this.pathDestination.getPath())).setMetric(Uint32.valueOf((int)this.pathDestination.getCost())).setStatus(ComputationStatus.Active);
                LOG.debug("  Found a valid path up to destination {}", (Object)cpathBuilder.getPathDescription());
            }
        }
        if (cpathBuilder.getStatus() == ComputationStatus.InProgress || cpathBuilder.getPathDescription().size() == 0) {
            cpathBuilder.setStatus(ComputationStatus.Failed);
        } else {
            cpathBuilder.setStatus(ComputationStatus.Completed);
        }
        return cpathBuilder.build();
    }

    private boolean relaxMultiConstraints(ConnectedEdge edge, CspfPath currentPath) {
        int totalCost;
        LOG.debug("    Start relaxing Multi Constraints on Edge {} to Vertex {}", (Object)edge, (Object)edge.getDestination());
        Long nextVertexKey = edge.getDestination().getKey();
        if (this.visitedVertices.containsKey(nextVertexKey)) {
            return false;
        }
        CspfPath nextPath = (CspfPath)this.processedPath.get(nextVertexKey);
        if (nextPath == null) {
            nextPath = new CspfPath(edge.getDestination());
            this.processedPath.put(nextPath.getVertexKey(), nextPath);
        }
        if ((totalCost = edge.getEdge().getEdgeAttributes().getTeMetric().intValue() + currentPath.getCost()) < nextPath.getCost()) {
            nextPath.setCost(totalCost).replacePath(currentPath.getPath()).addConnectedEdge(edge);
            this.priorityQueue.removeIf(path -> path.getVertexKey().equals(nextVertexKey));
            nextPath.setKey(totalCost);
            this.priorityQueue.add(nextPath);
            LOG.debug("    Added path to Vertex {} in the Priority Queue", (Object)nextPath.getVertex());
        }
        return this.pathDestination.equals(nextPath);
    }
}

