/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedVertex;

public class CspfPath
implements Comparable<CspfPath> {
    private final ConnectedVertex cvertex;
    private float pathLength = 0.0f;
    private int cost = Integer.MAX_VALUE;
    private int delay = 0xFFFFFF;
    private final ArrayList<ConnectedEdge> currentPath = new ArrayList();
    private Long predecessor;
    public static final byte UNKNOWN = 0;
    public static final byte ACTIVE = 1;
    public static final byte SELECTED = 2;
    public static final byte DOMINATED = 3;
    public static final byte PROCESSED = 4;
    private byte pathStatus;
    private Integer key = Integer.MAX_VALUE;

    public CspfPath(ConnectedVertex vertex) {
        this.cvertex = vertex;
    }

    public ConnectedVertex getVertex() {
        return this.cvertex;
    }

    public Long getVertexKey() {
        return this.cvertex.getKey();
    }

    public CspfPath setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public int getCost() {
        return this.cost;
    }

    public CspfPath setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public CspfPath addConnectedEdge(ConnectedEdge edge) {
        this.currentPath.add(edge);
        return this;
    }

    public CspfPath replacePath(List<ConnectedEdge> list) {
        if (list != null && list.size() != 0) {
            this.currentPath.clear();
        }
        this.currentPath.addAll(list);
        return this;
    }

    public List<ConnectedEdge> getPath() {
        return this.currentPath;
    }

    public int getPathCount() {
        return this.currentPath.size();
    }

    public CspfPath setPathStatus(byte status) {
        this.pathStatus = status;
        return this;
    }

    public byte getPathStatus() {
        return this.pathStatus;
    }

    public CspfPath setPredecessor(Long vertexId) {
        this.predecessor = vertexId;
        return this;
    }

    public Long getPredecessor() {
        return this.predecessor;
    }

    public CspfPath setPathLength(float length) {
        this.pathLength = length;
        return this;
    }

    public float getPathLength() {
        return this.pathLength;
    }

    public void clearPath() {
        this.currentPath.clear();
    }

    public CspfPath setKey(Integer key) {
        this.key = key;
        return this;
    }

    public Integer getKey() {
        return this.key;
    }

    @Override
    public int compareTo(CspfPath other) {
        return this.key.compareTo(other.getKey());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CspfPath)) {
            return false;
        }
        CspfPath cspfPath = (CspfPath)object;
        return this.getVertexKey().equals(cspfPath.getVertexKey());
    }

    public int hashCode() {
        return this.cvertex.getKey().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("_path={");
        for (ConnectedEdge edge : this.currentPath) {
            if (edge.getEdge() == null || edge.getEdge().getEdgeAttributes() == null) continue;
            sb.append(edge.getEdge().getEdgeAttributes().getRemoteAddress()).append(", ");
        }
        return sb.append('}').toString();
    }
}

