/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.algo.PathComputationAlgorithm;
import org.opendaylight.algo.PathComputationProvider;
import org.opendaylight.algo.impl.AbstractPathComputation;
import org.opendaylight.algo.impl.ConstrainedShortestPathFirst;
import org.opendaylight.algo.impl.Samcra;
import org.opendaylight.algo.impl.ShortestPathFirst;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.AlgorithmType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.GetConstrainedPathInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.GetConstrainedPathOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.GetConstrainedPathOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.PathComputationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev200120.PathConstraints;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathComputationServer
implements AutoCloseable,
PathComputationService,
PathComputationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PathComputationServer.class);
    private ObjectRegistration<PathComputationService> pathService;
    private RpcProviderService rpcProviderRegistry;
    private ConnectedGraphProvider graphProvider;
    private ConnectedGraph cgraph;

    public PathComputationServer(RpcProviderService rpcService, ConnectedGraphProvider graphProvider) {
        Preconditions.checkArgument((rpcService != null ? 1 : 0) != 0);
        Preconditions.checkArgument((graphProvider != null ? 1 : 0) != 0);
        this.rpcProviderRegistry = rpcService;
        this.graphProvider = graphProvider;
    }

    public void init() {
        this.pathService = this.rpcProviderRegistry.registerRpcImplementation(PathComputationService.class, (RpcService)this);
    }

    public ListenableFuture<RpcResult<GetConstrainedPathOutput>> getConstrainedPath(GetConstrainedPathInput input) {
        GetConstrainedPathOutputBuilder output = new GetConstrainedPathOutputBuilder();
        LOG.info("Got Path Computation Service request");
        this.cgraph = this.graphProvider.getConnectedGraph(input.getGraphName());
        if (this.cgraph == null) {
            output.setStatus(ComputationStatus.Failed);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "Unknown Graph Name").buildFuture();
        }
        PathComputationAlgorithm algo = this.getPathComputationAlgorithm(this.cgraph, input.getAlgorithm());
        if (algo == null) {
            output.setStatus(ComputationStatus.Failed);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "Unknown Path Computation Algorithm").buildFuture();
        }
        VertexKey source = new VertexKey(input.getSource());
        VertexKey destination = new VertexKey(input.getDestination());
        LOG.info("Call Path Computation {} algorithm for path from {} to {} with contraints {}", new Object[]{input.getAlgorithm().getName(), source, destination, input.getConstraints()});
        ConstrainedPath cpath = algo.computeP2pPath(source, destination, (PathConstraints)input.getConstraints());
        output.setPathDescription(cpath.getPathDescription()).setStatus(cpath.getStatus()).setComputedMetric(cpath.getMetric()).setComputedTeMetric(cpath.getTeMetric()).setComputedDelay(cpath.getDelay());
        return RpcResultBuilder.success((Object)output.build()).buildFuture();
    }

    @Override
    public void close() throws Exception {
        this.pathService.close();
    }

    public PathComputationAlgorithm getPathComputationAlgorithm(ConnectedGraph runningGraph, AlgorithmType algorithmType) {
        AbstractPathComputation algo = null;
        switch (algorithmType) {
            case Spf: {
                algo = new ShortestPathFirst(runningGraph);
                break;
            }
            case Cspf: {
                algo = new ConstrainedShortestPathFirst(runningGraph);
                break;
            }
            case Samcra: {
                algo = new Samcra(runningGraph);
                break;
            }
        }
        return algo;
    }
}

