/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.algo.PathComputationAlgorithm;
import org.opendaylight.algo.PathComputationProvider;
import org.opendaylight.algo.impl.AbstractPathComputation;
import org.opendaylight.algo.impl.ConstrainedShortestPathFirst;
import org.opendaylight.algo.impl.Samcra;
import org.opendaylight.algo.impl.ShortestPathFirst;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.AlgorithmType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.GetConstrainedPathInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.GetConstrainedPathOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.GetConstrainedPathOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathComputationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathConstraints;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, service={PathComputationProvider.class})
public final class PathComputationServer
implements AutoCloseable,
PathComputationService,
PathComputationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PathComputationServer.class);
    private final ConnectedGraphProvider graphProvider;
    private final Registration registration;

    @Inject
    @Activate
    public PathComputationServer(@Reference RpcProviderService rpcService, @Reference ConnectedGraphProvider graphProvider) {
        this.graphProvider = Objects.requireNonNull(graphProvider);
        this.registration = rpcService.registerRpcImplementation(PathComputationService.class, (RpcService)this);
    }

    public ListenableFuture<RpcResult<GetConstrainedPathOutput>> getConstrainedPath(GetConstrainedPathInput input) {
        GetConstrainedPathOutputBuilder output = new GetConstrainedPathOutputBuilder();
        LOG.info("Got Path Computation Service request");
        ConnectedGraph cgraph = this.graphProvider.getConnectedGraph(input.getGraphName());
        if (cgraph == null) {
            output.setStatus(ComputationStatus.Failed);
            return RpcResultBuilder.failed().withError(ErrorType.RPC, "Unknown Graph Name").buildFuture();
        }
        PathComputationAlgorithm algo = this.getPathComputationAlgorithm(cgraph, input.getAlgorithm());
        if (algo == null) {
            output.setStatus(ComputationStatus.Failed);
            return RpcResultBuilder.failed().withError(ErrorType.RPC, "Unknown Path Computation Algorithm").buildFuture();
        }
        VertexKey source = new VertexKey(input.getSource());
        VertexKey destination = new VertexKey(input.getDestination());
        LOG.info("Call Path Computation {} algorithm for path from {} to {} with contraints {}", new Object[]{input.getAlgorithm().getName(), source, destination, input.getConstraints()});
        ConstrainedPath cpath = algo.computeP2pPath(source, destination, (PathConstraints)input.getConstraints());
        output.setPathDescription(cpath.getPathDescription()).setStatus(cpath.getStatus()).setComputedMetric(cpath.getMetric()).setComputedTeMetric(cpath.getTeMetric()).setComputedDelay(cpath.getDelay());
        return RpcResultBuilder.success((Object)output.build()).buildFuture();
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.registration.close();
    }

    public PathComputationAlgorithm getPathComputationAlgorithm(ConnectedGraph runningGraph, AlgorithmType algorithmType) {
        AbstractPathComputation algo = null;
        switch (algorithmType) {
            case Spf: {
                algo = new ShortestPathFirst(runningGraph);
                break;
            }
            case Cspf: {
                algo = new ConstrainedShortestPathFirst(runningGraph);
                break;
            }
            case Samcra: {
                algo = new Samcra(runningGraph);
                break;
            }
        }
        return algo;
    }
}

