/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.algo.impl.AbstractPathComputation;
import org.opendaylight.algo.impl.CspfPath;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedVertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ConstrainedPathBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Samcra
extends AbstractPathComputation {
    private static final Logger LOG = LoggerFactory.getLogger(Samcra.class);
    private final HashMap<Long, SamcraPath> samcraPaths = new HashMap();
    int teCost = Integer.MAX_VALUE;
    int delayCost = 0xFFFFFF;

    public Samcra(ConnectedGraph graph) {
        super(graph);
    }

    @Override
    protected ConstrainedPath computeSimplePath(VertexKey src, VertexKey dst) {
        LOG.info("Start SAMCRA Path Computation from {} to {} with constraints {}", new Object[]{src, dst, this.constraints});
        ConstrainedPathBuilder cpathBuilder = this.initializePathComputation(src, dst);
        if (cpathBuilder.getStatus() != ComputationStatus.InProgress) {
            return cpathBuilder.build();
        }
        cpathBuilder.setBandwidth(this.constraints.getBandwidth()).setClassType(this.constraints.getClassType());
        this.samcraPaths.clear();
        this.samcraPaths.put(this.pathSource.getVertexKey(), new SamcraPath(this.pathSource.getVertex()));
        this.samcraPaths.put(this.pathDestination.getVertexKey(), new SamcraPath(this.pathDestination.getVertex()));
        while (this.priorityQueue.size() != 0) {
            CspfPath currentPath = (CspfPath)this.priorityQueue.poll();
            LOG.debug(" - Process path up to Vertex {} from Priority Queue", (Object)currentPath.getVertex());
            if (!currentPath.equals(this.pathSource)) {
                SamcraPath currentSamcraPath = this.samcraPaths.get(currentPath.getVertexKey());
                CspfPath currentCspfPath = currentSamcraPath.getCurrentPath();
                float queuePathLength = currentCspfPath.getPathLength();
                LOG.trace(" - Priority Queue output SamcraPaths {} CurrentPath {} with PathLength {}", new Object[]{currentSamcraPath.currentPath, currentCspfPath, Float.valueOf(queuePathLength)});
            }
            List edges = currentPath.getVertex().getOutputConnectedEdges();
            float currentPathLength = 1.0f;
            for (ConnectedEdge edge : edges) {
                if (this.pruneEdge(edge, currentPath)) {
                    LOG.trace(" - Prune Edge {}", (Object)edge);
                    continue;
                }
                float pathLength = this.relaxSamcra(edge, currentPath, this.pathSource);
                if (!(pathLength > 0.0f) || !(pathLength <= currentPathLength)) continue;
                SamcraPath finalPath = this.samcraPaths.get(this.pathDestination.getVertexKey());
                cpathBuilder.setPathDescription(this.getPathDescription(finalPath.getCurrentPath().getPath())).setTeMetric(Uint32.valueOf((int)finalPath.getCurrentPath().getCost())).setDelay(new Delay(Uint32.valueOf((int)finalPath.getCurrentPath().getDelay()))).setStatus(ComputationStatus.Active);
                LOG.debug(" - Path to destination found and registered {}", (Object)cpathBuilder.getPathDescription());
                currentPathLength = pathLength;
            }
            float previousLength = 1.0f;
            CspfPath selectedPath = null;
            if (currentPath.equals(this.pathSource)) continue;
            LOG.debug(" - Processing current path {} up to {} from Priority Queue", (Object)currentPath, (Object)currentPath.getVertex());
            SamcraPath currentSamcraPath = this.samcraPaths.get(currentPath.getVertexKey());
            currentSamcraPath.decrementPathCount();
            for (CspfPath testedPath : currentSamcraPath.getPathList()) {
                LOG.debug(" - Testing path {} with status {} ", (Object)testedPath, (Object)testedPath.getPathStatus());
                if (testedPath.getPathStatus() == 2) {
                    testedPath.setPathStatus((byte)4);
                    continue;
                }
                if (testedPath.getPathStatus() != 1 || !(testedPath.getPathLength() < previousLength)) continue;
                selectedPath = testedPath;
                previousLength = testedPath.getPathLength();
            }
            if (selectedPath != null) {
                selectedPath.setPathStatus((byte)2);
                currentSamcraPath.setCurrentPath(selectedPath);
                this.priorityQueue.add(selectedPath);
                LOG.debug(" - Add path {} to Priority Queue. New path count {} ", (Object)selectedPath, (Object)currentSamcraPath.getPathCount());
                continue;
            }
            currentSamcraPath.setCurrentPath(null);
        }
        return cpathBuilder.setStatus(cpathBuilder.getStatus() == ComputationStatus.InProgress || cpathBuilder.getPathDescription().size() == 0 ? ComputationStatus.NoPath : ComputationStatus.Completed).build();
    }

    private float relaxSamcra(ConnectedEdge edge, CspfPath currentPath, CspfPath source) {
        LOG.debug("   - Start SAMCRA relaxing Edge {} to Vertex {}", (Object)edge, (Object)edge.getDestination());
        CspfPath nextVertexPath = (CspfPath)this.processedPath.get(edge.getDestination().getKey());
        if (nextVertexPath == null) {
            nextVertexPath = new CspfPath(edge.getDestination());
            this.processedPath.put(nextVertexPath.getVertexKey(), nextVertexPath);
            SamcraPath nextSamcraPath = new SamcraPath(edge.getDestination());
            this.samcraPaths.put(nextVertexPath.getVertexKey(), nextSamcraPath);
            LOG.debug("     - Next connected vertex {} does not exist, create it with new Samcra Path {}", (Object)nextSamcraPath.getVertex(), (Object)nextVertexPath);
        }
        Long predecessorId = 0L;
        if (!currentPath.equals(source)) {
            LOG.debug("     - Check predecessor");
            SamcraPath currentSamcraPath = this.samcraPaths.get(currentPath.getVertexKey());
            CspfPath currentVertexPath = currentSamcraPath.getCurrentPath();
            predecessorId = currentVertexPath.getPredecessor();
        }
        if (predecessorId.equals(nextVertexPath.getVertexKey())) {
            LOG.debug("     - Skip Edge because next vertex {} is predecessor of {}", (Object)nextVertexPath.getVertexKey(), (Object)predecessorId);
            return 0.0f;
        }
        this.teCost = edge.getEdge().getEdgeAttributes().getTeMetric() != null ? edge.getEdge().getEdgeAttributes().getTeMetric().intValue() + currentPath.getCost() : currentPath.getCost();
        this.delayCost = edge.getEdge().getEdgeAttributes().getDelay() != null ? edge.getEdge().getEdgeAttributes().getDelay().getValue().intValue() + currentPath.getDelay() : currentPath.getDelay();
        SamcraPath samcraPath = this.samcraPaths.get(nextVertexPath.getVertexKey());
        if (this.isPathDominated(samcraPath)) {
            LOG.debug("     - Skip Edge because new path is dominated");
            return 0.0f;
        }
        CspfPath newPath = this.createNonDominatedPath(edge, nextVertexPath.getVertex(), currentPath);
        CspfPath currentSamcraPath = samcraPath.getCurrentPath();
        if (currentSamcraPath == null) {
            LOG.debug("     - Add new Path {}", (Object)newPath);
            if (!newPath.equals(this.pathDestination)) {
                this.priorityQueue.add(newPath);
            }
            newPath.setPathStatus((byte)2);
            samcraPath.setCurrentPath(newPath);
        } else if (newPath.getPathLength() < currentSamcraPath.getPathLength()) {
            LOG.debug("     - Update current path up to {} with new path {}", (Object)currentSamcraPath.getVertex(), (Object)newPath);
            samcraPath.getPathList().stream().filter(path -> path.getPathStatus() == 2).forEach(path -> path.setPathStatus((byte)1));
            if (!newPath.equals(this.pathDestination)) {
                this.priorityQueue.removeIf(path -> path.getVertexKey().equals(newPath.getVertexKey()));
                this.priorityQueue.add(newPath);
            }
            newPath.setPathStatus((byte)2);
            samcraPath.setCurrentPath(newPath);
        }
        samcraPath.addPath(newPath);
        samcraPath.incrementPathCount();
        LOG.debug("     - Add path {} to {}\u00a0with index {}/{}", new Object[]{samcraPath.getCurrentPath(), samcraPath.getCurrentPath().getVertex(), samcraPath.getVertex().getKey(), samcraPath.getPathCount()});
        this.samcraPaths.put(samcraPath.getVertex().getKey(), samcraPath);
        if (samcraPath.getVertex().getKey().equals(this.pathDestination.getVertexKey())) {
            return samcraPath.getCurrentPath().getPathLength();
        }
        return 0.0f;
    }

    private boolean isPathDominated(SamcraPath samcraPath) {
        LOG.debug("       - Check path domination");
        Uint32 teMetric = this.constraints.getTeMetric();
        Uint32 delay = this.constraints.getDelay() != null ? this.constraints.getDelay().getValue() : null;
        for (CspfPath testedPath : samcraPath.getPathList()) {
            boolean pathCostDominated = false;
            boolean pathDelayDominated = false;
            boolean testedPathCostDominated = false;
            boolean testedPathDelayDominated = false;
            LOG.debug("       - Check if path {} is dominated or dominates", (Object)testedPath);
            if (testedPath.getPathStatus() == 3) continue;
            if (teMetric != null) {
                if (this.teCost >= testedPath.getCost()) {
                    pathCostDominated = true;
                } else {
                    testedPathCostDominated = true;
                }
            }
            if (delay != null) {
                if (this.delayCost >= testedPath.getDelay()) {
                    pathDelayDominated = true;
                } else {
                    testedPathDelayDominated = true;
                }
            }
            if (teMetric != null && pathCostDominated && (pathDelayDominated || delay == null) || teMetric == null && delay != null && pathDelayDominated) {
                LOG.debug("       - New path is dominated by teCost {} and/or delayCost {}", (Object)this.teCost, (Object)this.delayCost);
                return true;
            }
            if ((teMetric == null || !testedPathCostDominated || !testedPathDelayDominated && delay != null) && (teMetric != null || delay == null || !testedPathDelayDominated)) continue;
            testedPath.setPathStatus((byte)3);
            samcraPath.decrementPathCount();
            LOG.debug("       - New path dominates existing path with teCost {} and/or delayCost {}", (Object)testedPath.getCost(), (Object)testedPath.getDelay());
        }
        return false;
    }

    private CspfPath createNonDominatedPath(ConnectedEdge edge, ConnectedVertex vertex, CspfPath cspfPath) {
        float pathLength = 1.0f;
        Uint32 metric = this.constraints.getTeMetric();
        Uint32 delay = this.constraints.getDelay() != null ? this.constraints.getDelay().getValue() : null;
        LOG.debug("       - Create new non dominated path");
        float teLength = 0.0f;
        if (metric != null && metric.intValue() > 0) {
            pathLength = teLength = (float)this.teCost / (float)metric.intValue();
        }
        float delayLength = 0.0f;
        if (delay != null && delay.intValue() > 0 && (delayLength = (float)this.delayCost / (float)delay.intValue()) > teLength) {
            pathLength = delayLength;
        }
        CspfPath newPath = new CspfPath(vertex).setCost(this.teCost).setDelay(this.delayCost).setKey((int)(100.0f * pathLength)).setPathStatus((byte)1).setPathLength(pathLength).setPredecessor(cspfPath.getVertexKey()).replacePath(cspfPath.getPath()).addConnectedEdge(edge);
        LOG.debug("       - Created new Path {} with length {}, cost {} and delay {}", new Object[]{newPath, Float.valueOf(pathLength), this.teCost, this.delayCost});
        return newPath;
    }

    private static class SamcraPath {
        private final ArrayList<CspfPath> pathList = new ArrayList();
        private final ConnectedVertex cvertex;
        private int pathCount;
        private CspfPath currentPath = null;

        SamcraPath(ConnectedVertex vertex) {
            this.cvertex = vertex;
            this.pathCount = 0;
        }

        public ConnectedVertex getVertex() {
            return this.cvertex;
        }

        public void decrementPathCount() {
            --this.pathCount;
        }

        public void incrementPathCount() {
            ++this.pathCount;
        }

        public int getPathCount() {
            return this.pathCount;
        }

        public void setCurrentPath(CspfPath path) {
            this.currentPath = path;
        }

        public CspfPath getCurrentPath() {
            return this.currentPath;
        }

        public void addPath(CspfPath path) {
            this.pathList.add(path);
        }

        public ArrayList<CspfPath> getPathList() {
            return this.pathList;
        }
    }
}

