/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.algo.impl;

import java.util.HashMap;
import java.util.List;
import org.opendaylight.algo.impl.AbstractPathComputation;
import org.opendaylight.algo.impl.CspfPath;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ConstrainedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ConstrainedPathBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortestPathFirst
extends AbstractPathComputation {
    private static final Logger LOG = LoggerFactory.getLogger(ShortestPathFirst.class);
    private final HashMap<Long, CspfPath> visitedVertices = new HashMap();

    public ShortestPathFirst(ConnectedGraph graph) {
        super(graph);
    }

    @Override
    protected ConstrainedPath computeSimplePath(VertexKey src, VertexKey dst) {
        int currentCost = Integer.MAX_VALUE;
        LOG.info("Start SPF Path Computation from {} to {} with constraints {}", new Object[]{src, dst, this.constraints});
        ConstrainedPathBuilder cpathBuilder = this.initializePathComputation(src, dst);
        if (cpathBuilder.getStatus() != ComputationStatus.InProgress) {
            LOG.warn("Initial configurations are not met. Abort!");
            return cpathBuilder.build();
        }
        this.visitedVertices.clear();
        while (this.priorityQueue.size() != 0) {
            CspfPath currentPath = (CspfPath)this.priorityQueue.poll();
            this.visitedVertices.put(currentPath.getVertexKey(), currentPath);
            LOG.debug("Process path to Vertex {} from Priority Queue", (Object)currentPath.getVertex());
            List edges = currentPath.getVertex().getOutputConnectedEdges();
            for (ConnectedEdge edge : edges) {
                if (this.pruneEdge(edge, currentPath)) {
                    LOG.trace("  Prune Edge {}", (Object)edge);
                    continue;
                }
                if (!this.relax(edge, currentPath) || this.pathDestination.getCost() >= currentCost) continue;
                currentCost = this.pathDestination.getCost();
                cpathBuilder.setPathDescription(this.getPathDescription(this.pathDestination.getPath())).setMetric(Uint32.valueOf((int)this.pathDestination.getCost())).setStatus(ComputationStatus.Active);
                LOG.debug("  Found a valid path up to destination {}", (Object)cpathBuilder.getPathDescription());
            }
        }
        return cpathBuilder.setStatus(cpathBuilder.getStatus() == ComputationStatus.InProgress || cpathBuilder.getPathDescription().size() == 0 ? ComputationStatus.NoPath : ComputationStatus.Completed).build();
    }

    private boolean relax(ConnectedEdge edge, CspfPath currentPath) {
        LOG.debug("    Start relaxing Edge {} to Vertex {}", (Object)edge, (Object)edge.getDestination());
        Long nextVertexKey = edge.getDestination().getKey();
        if (this.visitedVertices.containsKey(nextVertexKey)) {
            return false;
        }
        CspfPath nextPath = (CspfPath)this.processedPath.get(nextVertexKey);
        if (nextPath == null) {
            nextPath = new CspfPath(edge.getDestination());
            this.processedPath.put(nextPath.getVertexKey(), nextPath);
        }
        int totalCost = edge.getEdge().getEdgeAttributes().getMetric().intValue() + currentPath.getCost();
        if (nextPath.getCost() > totalCost) {
            nextPath.setCost(totalCost).replacePath(currentPath.getPath()).addConnectedEdge(edge);
            this.priorityQueue.removeIf(path -> path.getVertexKey().equals(nextVertexKey));
            nextPath.setKey(totalCost);
            this.priorityQueue.add(nextPath);
            LOG.debug("    Added path to Vertex {} in the Priority Queue with weight {}", (Object)nextPath.getVertex(), (Object)nextPath.getKey());
        }
        return this.pathDestination.equals(nextPath);
    }
}

