/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.RouteDistinguisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

public interface Peer
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer");

    public Class<? extends Peer> implementedInterface();

    public @Nullable PeerType getType();

    public @Nullable PeerDistinguisher getPeerDistinguisher();

    public @Nullable IpAddress getAddress();

    public @Nullable AsNumber getAs();

    public @Nullable Ipv4Address getBgpId();

    public static final class PeerDistinguisher
    implements TypeObject {
        private final RouteDistinguisher _routeDistinguisher;
        private final byte[] _binary;

        public PeerDistinguisher(RouteDistinguisher _routeDistinguisher) {
            this._routeDistinguisher = _routeDistinguisher;
            this._binary = null;
        }

        private static void check_binaryLength(byte[] value) {
            int length = value.length;
            if (length == 8) {
                return;
            }
            CodeHelpers.throwInvalidLength((String)"[[8..8]]", (byte[])value);
        }

        public PeerDistinguisher(byte[] _binary) {
            PeerDistinguisher.check_binaryLength(_binary);
            this._binary = _binary;
            this._routeDistinguisher = null;
        }

        public PeerDistinguisher(PeerDistinguisher source) {
            this._routeDistinguisher = source._routeDistinguisher;
            this._binary = source._binary == null ? null : (byte[])source._binary.clone();
        }

        public String stringValue() {
            if (this._routeDistinguisher != null) {
                return this._routeDistinguisher.stringValue();
            }
            if (this._binary != null) {
                return new String(this._binary);
            }
            throw new IllegalStateException("No value assinged");
        }

        public RouteDistinguisher getRouteDistinguisher() {
            return this._routeDistinguisher;
        }

        public byte[] getBinary() {
            return this._binary == null ? null : (byte[])this._binary.clone();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._routeDistinguisher);
            result = 31 * result + Arrays.hashCode(this._binary);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerDistinguisher other = (PeerDistinguisher)obj;
            if (!Objects.equals(this._routeDistinguisher, other._routeDistinguisher)) {
                return false;
            }
            return Arrays.equals(this._binary, other._binary);
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PeerDistinguisher.class);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routeDistinguisher", (Object)this._routeDistinguisher);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_binary", (byte[])this._binary);
            return helper.toString();
        }
    }
}

