/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum PeerType implements Enumeration
{
    Global(0, "global"),
    L3vpn(1, "l3vpn"),
    Local(2, "local");

    private static final Map<String, PeerType> NAME_MAP;
    private static final Map<Integer, PeerType> VALUE_MAP;
    private final String name;
    private final int value;

    private PeerType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<PeerType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static PeerType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (PeerType enumItem : PeerType.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

