/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerUp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.header.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.SentOpen;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerUpNotificationBuilder
implements Builder<PeerUpNotification> {
    private Information _information;
    private IpAddress _localAddress;
    private PortNumber _localPort;
    private PeerHeader _peerHeader;
    private ReceivedOpen _receivedOpen;
    private PortNumber _remotePort;
    private SentOpen _sentOpen;
    Map<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>> augmentation = Collections.emptyMap();

    public PeerUpNotificationBuilder() {
    }

    public PeerUpNotificationBuilder(PeerUp arg) {
        this._localAddress = arg.getLocalAddress();
        this._localPort = arg.getLocalPort();
        this._remotePort = arg.getRemotePort();
        this._sentOpen = arg.getSentOpen();
        this._receivedOpen = arg.getReceivedOpen();
        this._information = arg.getInformation();
    }

    public PeerUpNotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerHeader arg) {
        this._peerHeader = arg.getPeerHeader();
    }

    public PeerUpNotificationBuilder(PeerUpNotification base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>>(aug);
        }
        this._information = base.getInformation();
        this._localAddress = base.getLocalAddress();
        this._localPort = base.getLocalPort();
        this._peerHeader = base.getPeerHeader();
        this._receivedOpen = base.getReceivedOpen();
        this._remotePort = base.getRemotePort();
        this._sentOpen = base.getSentOpen();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PeerUp) {
            this._localAddress = ((PeerUp)arg).getLocalAddress();
            this._localPort = ((PeerUp)arg).getLocalPort();
            this._remotePort = ((PeerUp)arg).getRemotePort();
            this._sentOpen = ((PeerUp)arg).getSentOpen();
            this._receivedOpen = ((PeerUp)arg).getReceivedOpen();
            this._information = ((PeerUp)arg).getInformation();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerHeader) {
            this._peerHeader = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerHeader)arg).getPeerHeader();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerUp, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerHeader]");
    }

    public Information getInformation() {
        return this._information;
    }

    public IpAddress getLocalAddress() {
        return this._localAddress;
    }

    public PortNumber getLocalPort() {
        return this._localPort;
    }

    public PeerHeader getPeerHeader() {
        return this._peerHeader;
    }

    public ReceivedOpen getReceivedOpen() {
        return this._receivedOpen;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public SentOpen getSentOpen() {
        return this._sentOpen;
    }

    public <E$$ extends Augmentation<PeerUpNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PeerUpNotificationBuilder setInformation(Information value) {
        this._information = value;
        return this;
    }

    public PeerUpNotificationBuilder setLocalAddress(IpAddress value) {
        this._localAddress = value;
        return this;
    }

    public PeerUpNotificationBuilder setLocalPort(PortNumber value) {
        this._localPort = value;
        return this;
    }

    public PeerUpNotificationBuilder setPeerHeader(PeerHeader value) {
        this._peerHeader = value;
        return this;
    }

    public PeerUpNotificationBuilder setReceivedOpen(ReceivedOpen value) {
        this._receivedOpen = value;
        return this;
    }

    public PeerUpNotificationBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public PeerUpNotificationBuilder setSentOpen(SentOpen value) {
        this._sentOpen = value;
        return this;
    }

    public PeerUpNotificationBuilder addAugmentation(Class<? extends Augmentation<PeerUpNotification>> augmentationType, Augmentation<PeerUpNotification> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerUpNotificationBuilder removeAugmentation(Class<? extends Augmentation<PeerUpNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PeerUpNotification build() {
        return new PeerUpNotificationImpl(this);
    }

    private static final class PeerUpNotificationImpl
    extends AbstractAugmentable<PeerUpNotification>
    implements PeerUpNotification {
        private final Information _information;
        private final IpAddress _localAddress;
        private final PortNumber _localPort;
        private final PeerHeader _peerHeader;
        private final ReceivedOpen _receivedOpen;
        private final PortNumber _remotePort;
        private final SentOpen _sentOpen;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PeerUpNotificationImpl(PeerUpNotificationBuilder base) {
            super(base.augmentation);
            this._information = base.getInformation();
            this._localAddress = base.getLocalAddress();
            this._localPort = base.getLocalPort();
            this._peerHeader = base.getPeerHeader();
            this._receivedOpen = base.getReceivedOpen();
            this._remotePort = base.getRemotePort();
            this._sentOpen = base.getSentOpen();
        }

        @Override
        public Information getInformation() {
            return this._information;
        }

        @Override
        public IpAddress getLocalAddress() {
            return this._localAddress;
        }

        @Override
        public PortNumber getLocalPort() {
            return this._localPort;
        }

        @Override
        public PeerHeader getPeerHeader() {
            return this._peerHeader;
        }

        @Override
        public ReceivedOpen getReceivedOpen() {
            return this._receivedOpen;
        }

        @Override
        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        @Override
        public SentOpen getSentOpen() {
            return this._sentOpen;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._information);
            result = 31 * result + Objects.hashCode(this._localAddress);
            result = 31 * result + Objects.hashCode(this._localPort);
            result = 31 * result + Objects.hashCode(this._peerHeader);
            result = 31 * result + Objects.hashCode(this._receivedOpen);
            result = 31 * result + Objects.hashCode(this._remotePort);
            result = 31 * result + Objects.hashCode(this._sentOpen);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerUpNotification.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerUpNotification other = (PeerUpNotification)obj;
            if (!Objects.equals(this._information, other.getInformation())) {
                return false;
            }
            if (!Objects.equals(this._localAddress, other.getLocalAddress())) {
                return false;
            }
            if (!Objects.equals(this._localPort, other.getLocalPort())) {
                return false;
            }
            if (!Objects.equals(this._peerHeader, other.getPeerHeader())) {
                return false;
            }
            if (!Objects.equals(this._receivedOpen, other.getReceivedOpen())) {
                return false;
            }
            if (!Objects.equals(this._remotePort, other.getRemotePort())) {
                return false;
            }
            if (!Objects.equals(this._sentOpen, other.getSentOpen())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerUpNotificationImpl otherImpl = (PeerUpNotificationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PeerUpNotification");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_information", (Object)this._information);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localAddress", (Object)this._localAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localPort", (Object)this._localPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerHeader", (Object)this._peerHeader);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_receivedOpen", (Object)this._receivedOpen);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_remotePort", (Object)this._remotePort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sentOpen", (Object)this._sentOpen);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

