/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.FsmEventCode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FsmEventCodeBuilder
implements Builder<FsmEventCode> {
    private Integer _fsmEventCode;
    Map<Class<? extends Augmentation<FsmEventCode>>, Augmentation<FsmEventCode>> augmentation = Collections.emptyMap();

    public FsmEventCodeBuilder() {
    }

    public FsmEventCodeBuilder(FsmEventCode base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FsmEventCode>>, Augmentation<FsmEventCode>>(aug);
        }
        this._fsmEventCode = base.getFsmEventCode();
    }

    public Integer getFsmEventCode() {
        return this._fsmEventCode;
    }

    public <E$$ extends Augmentation<FsmEventCode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkFsmEventCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public FsmEventCodeBuilder setFsmEventCode(Integer value) {
        if (value != null) {
            FsmEventCodeBuilder.checkFsmEventCodeRange(value);
        }
        this._fsmEventCode = value;
        return this;
    }

    public FsmEventCodeBuilder addAugmentation(Class<? extends Augmentation<FsmEventCode>> augmentationType, Augmentation<FsmEventCode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FsmEventCode>>, Augmentation<FsmEventCode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FsmEventCodeBuilder removeAugmentation(Class<? extends Augmentation<FsmEventCode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FsmEventCode build() {
        return new FsmEventCodeImpl(this);
    }

    private static final class FsmEventCodeImpl
    extends AbstractAugmentable<FsmEventCode>
    implements FsmEventCode {
        private final Integer _fsmEventCode;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FsmEventCodeImpl(FsmEventCodeBuilder base) {
            super(base.augmentation);
            this._fsmEventCode = base.getFsmEventCode();
        }

        @Override
        public Integer getFsmEventCode() {
            return this._fsmEventCode;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._fsmEventCode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FsmEventCode.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            FsmEventCode other = (FsmEventCode)obj;
            if (!Objects.equals(this._fsmEventCode, other.getFsmEventCode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FsmEventCodeImpl otherImpl = (FsmEventCodeImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"FsmEventCode");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_fsmEventCode", (Object)this._fsmEventCode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

