/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.header;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.header.PeerHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerHeaderBuilder
implements Builder<PeerHeader> {
    private IpAddress _address;
    private AdjRibInType _adjRibInType;
    private AsNumber _as;
    private Ipv4Address _bgpId;
    private Peer.PeerDistinguisher _peerDistinguisher;
    private org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp _timestampMicro;
    private org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp _timestampSec;
    private PeerType _type;
    private Boolean _ipv4;
    Map<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> augmentation = Collections.emptyMap();

    public PeerHeaderBuilder() {
    }

    public PeerHeaderBuilder(Peer arg) {
        this._type = arg.getType();
        this._peerDistinguisher = arg.getPeerDistinguisher();
        this._address = arg.getAddress();
        this._as = arg.getAs();
        this._bgpId = arg.getBgpId();
    }

    public PeerHeaderBuilder(Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public PeerHeaderBuilder(PeerHeader base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>>(aug);
        }
        this._address = base.getAddress();
        this._adjRibInType = base.getAdjRibInType();
        this._as = base.getAs();
        this._bgpId = base.getBgpId();
        this._peerDistinguisher = base.getPeerDistinguisher();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
        this._type = base.getType();
        this._ipv4 = base.isIpv4();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peer) {
            this._type = ((Peer)arg).getType();
            this._peerDistinguisher = ((Peer)arg).getPeerDistinguisher();
            this._address = ((Peer)arg).getAddress();
            this._as = ((Peer)arg).getAs();
            this._bgpId = ((Peer)arg).getBgpId();
            isValidArg = true;
        }
        if (arg instanceof Timestamp) {
            this._timestampSec = ((Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp]");
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public AdjRibInType getAdjRibInType() {
        return this._adjRibInType;
    }

    public AsNumber getAs() {
        return this._as;
    }

    public Ipv4Address getBgpId() {
        return this._bgpId;
    }

    public Peer.PeerDistinguisher getPeerDistinguisher() {
        return this._peerDistinguisher;
    }

    public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampMicro() {
        return this._timestampMicro;
    }

    public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampSec() {
        return this._timestampSec;
    }

    public PeerType getType() {
        return this._type;
    }

    public Boolean isIpv4() {
        return this._ipv4;
    }

    public <E$$ extends Augmentation<PeerHeader>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PeerHeaderBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public PeerHeaderBuilder setAdjRibInType(AdjRibInType value) {
        this._adjRibInType = value;
        return this;
    }

    public PeerHeaderBuilder setAs(AsNumber value) {
        this._as = value;
        return this;
    }

    public PeerHeaderBuilder setBgpId(Ipv4Address value) {
        this._bgpId = value;
        return this;
    }

    public PeerHeaderBuilder setPeerDistinguisher(Peer.PeerDistinguisher value) {
        this._peerDistinguisher = value;
        return this;
    }

    public PeerHeaderBuilder setTimestampMicro(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp value) {
        this._timestampMicro = value;
        return this;
    }

    public PeerHeaderBuilder setTimestampSec(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp value) {
        this._timestampSec = value;
        return this;
    }

    public PeerHeaderBuilder setType(PeerType value) {
        this._type = value;
        return this;
    }

    public PeerHeaderBuilder setIpv4(Boolean value) {
        this._ipv4 = value;
        return this;
    }

    public PeerHeaderBuilder addAugmentation(Class<? extends Augmentation<PeerHeader>> augmentationType, Augmentation<PeerHeader> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerHeaderBuilder removeAugmentation(Class<? extends Augmentation<PeerHeader>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PeerHeader build() {
        return new PeerHeaderImpl(this);
    }

    private static final class PeerHeaderImpl
    extends AbstractAugmentable<PeerHeader>
    implements PeerHeader {
        private final IpAddress _address;
        private final AdjRibInType _adjRibInType;
        private final AsNumber _as;
        private final Ipv4Address _bgpId;
        private final Peer.PeerDistinguisher _peerDistinguisher;
        private final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp _timestampMicro;
        private final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp _timestampSec;
        private final PeerType _type;
        private final Boolean _ipv4;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PeerHeaderImpl(PeerHeaderBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._adjRibInType = base.getAdjRibInType();
            this._as = base.getAs();
            this._bgpId = base.getBgpId();
            this._peerDistinguisher = base.getPeerDistinguisher();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
            this._type = base.getType();
            this._ipv4 = base.isIpv4();
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public AdjRibInType getAdjRibInType() {
            return this._adjRibInType;
        }

        @Override
        public AsNumber getAs() {
            return this._as;
        }

        @Override
        public Ipv4Address getBgpId() {
            return this._bgpId;
        }

        @Override
        public Peer.PeerDistinguisher getPeerDistinguisher() {
            return this._peerDistinguisher;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampMicro() {
            return this._timestampMicro;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampSec() {
            return this._timestampSec;
        }

        @Override
        public PeerType getType() {
            return this._type;
        }

        @Override
        public Boolean isIpv4() {
            return this._ipv4;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode((Object)this._adjRibInType);
            result = 31 * result + Objects.hashCode(this._as);
            result = 31 * result + Objects.hashCode(this._bgpId);
            result = 31 * result + Objects.hashCode(this._peerDistinguisher);
            result = 31 * result + Objects.hashCode(this._timestampMicro);
            result = 31 * result + Objects.hashCode(this._timestampSec);
            result = 31 * result + Objects.hashCode((Object)this._type);
            result = 31 * result + Objects.hashCode(this._ipv4);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerHeader.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerHeader other = (PeerHeader)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals((Object)this._adjRibInType, (Object)other.getAdjRibInType())) {
                return false;
            }
            if (!Objects.equals(this._as, other.getAs())) {
                return false;
            }
            if (!Objects.equals(this._bgpId, other.getBgpId())) {
                return false;
            }
            if (!Objects.equals(this._peerDistinguisher, other.getPeerDistinguisher())) {
                return false;
            }
            if (!Objects.equals(this._timestampMicro, other.getTimestampMicro())) {
                return false;
            }
            if (!Objects.equals(this._timestampSec, other.getTimestampSec())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (!Objects.equals(this._ipv4, other.isIpv4())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerHeaderImpl otherImpl = (PeerHeaderImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PeerHeader");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_adjRibInType", (Object)((Object)this._adjRibInType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_as", (Object)this._as);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bgpId", (Object)this._bgpId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerDistinguisher", (Object)this._peerDistinguisher);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timestampMicro", (Object)this._timestampMicro);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timestampSec", (Object)this._timestampSec);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", (Object)((Object)this._type));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipv4", (Object)this._ipv4);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

