/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.OpenMsg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.SentOpen;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SentOpenBuilder
implements Builder<SentOpen> {
    private Ipv4Address _bgpIdentifier;
    private List<BgpParameters> _bgpParameters;
    private Integer _holdTimer;
    private Integer _myAsNumber;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<SentOpen>>, Augmentation<SentOpen>> augmentation = Collections.emptyMap();

    public SentOpenBuilder() {
    }

    public SentOpenBuilder(OpenMsg arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }

    public SentOpenBuilder(OpenMessage arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }

    public SentOpenBuilder(SentOpen base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SentOpen>>, Augmentation<SentOpen>>(aug);
        }
        this._bgpIdentifier = base.getBgpIdentifier();
        this._bgpParameters = base.getBgpParameters();
        this._holdTimer = base.getHoldTimer();
        this._myAsNumber = base.getMyAsNumber();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenMsg) {
            isValidArg = true;
        }
        if (arg instanceof OpenMessage) {
            this._version = ((OpenMessage)arg).getVersion();
            this._myAsNumber = ((OpenMessage)arg).getMyAsNumber();
            this._holdTimer = ((OpenMessage)arg).getHoldTimer();
            this._bgpIdentifier = ((OpenMessage)arg).getBgpIdentifier();
            this._bgpParameters = ((OpenMessage)arg).getBgpParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.OpenMsg, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.OpenMessage]");
    }

    public Ipv4Address getBgpIdentifier() {
        return this._bgpIdentifier;
    }

    public List<BgpParameters> getBgpParameters() {
        return this._bgpParameters;
    }

    public Integer getHoldTimer() {
        return this._holdTimer;
    }

    public Integer getMyAsNumber() {
        return this._myAsNumber;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<SentOpen>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SentOpenBuilder setBgpIdentifier(Ipv4Address value) {
        this._bgpIdentifier = value;
        return this;
    }

    public SentOpenBuilder setBgpParameters(List<BgpParameters> values) {
        this._bgpParameters = values;
        return this;
    }

    private static void checkHoldTimerRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public SentOpenBuilder setHoldTimer(Integer value) {
        if (value != null) {
            SentOpenBuilder.checkHoldTimerRange(value);
        }
        this._holdTimer = value;
        return this;
    }

    private static void checkMyAsNumberRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public SentOpenBuilder setMyAsNumber(Integer value) {
        if (value != null) {
            SentOpenBuilder.checkMyAsNumberRange(value);
        }
        this._myAsNumber = value;
        return this;
    }

    public SentOpenBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public SentOpenBuilder addAugmentation(Class<? extends Augmentation<SentOpen>> augmentationType, Augmentation<SentOpen> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SentOpen>>, Augmentation<SentOpen>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SentOpenBuilder removeAugmentation(Class<? extends Augmentation<SentOpen>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SentOpen build() {
        return new SentOpenImpl(this);
    }

    private static final class SentOpenImpl
    extends AbstractAugmentable<SentOpen>
    implements SentOpen {
        private final Ipv4Address _bgpIdentifier;
        private final List<BgpParameters> _bgpParameters;
        private final Integer _holdTimer;
        private final Integer _myAsNumber;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SentOpenImpl(SentOpenBuilder base) {
            super(base.augmentation);
            this._bgpIdentifier = base.getBgpIdentifier();
            this._bgpParameters = base.getBgpParameters();
            this._holdTimer = base.getHoldTimer();
            this._myAsNumber = base.getMyAsNumber();
            this._version = base.getVersion();
        }

        public Ipv4Address getBgpIdentifier() {
            return this._bgpIdentifier;
        }

        public List<BgpParameters> getBgpParameters() {
            return this._bgpParameters;
        }

        public Integer getHoldTimer() {
            return this._holdTimer;
        }

        public Integer getMyAsNumber() {
            return this._myAsNumber;
        }

        public ProtocolVersion getVersion() {
            return this._version;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bgpIdentifier);
            result = 31 * result + Objects.hashCode(this._bgpParameters);
            result = 31 * result + Objects.hashCode(this._holdTimer);
            result = 31 * result + Objects.hashCode(this._myAsNumber);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SentOpen.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            SentOpen other = (SentOpen)obj;
            if (!Objects.equals(this._bgpIdentifier, other.getBgpIdentifier())) {
                return false;
            }
            if (!Objects.equals(this._bgpParameters, other.getBgpParameters())) {
                return false;
            }
            if (!Objects.equals(this._holdTimer, other.getHoldTimer())) {
                return false;
            }
            if (!Objects.equals(this._myAsNumber, other.getMyAsNumber())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SentOpenImpl otherImpl = (SentOpenImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SentOpen");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bgpIdentifier", (Object)this._bgpIdentifier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bgpParameters", this._bgpParameters);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_holdTimer", (Object)this._holdTimer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_myAsNumber", (Object)this._myAsNumber);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_version", (Object)this._version);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

