/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.ServerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.BmpMonitorConfigKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.server.config.Server;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.MonitorId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BmpMonitorConfigBuilder
implements Builder<BmpMonitorConfig> {
    private MonitorId _monitorId;
    private List<MonitoredRouter> _monitoredRouter;
    private Server _server;
    private BmpMonitorConfigKey key;
    Map<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> augmentation = Collections.emptyMap();

    public BmpMonitorConfigBuilder() {
    }

    public BmpMonitorConfigBuilder(ServerConfig arg) {
        this._server = arg.getServer();
    }

    public BmpMonitorConfigBuilder(BmpMonitorConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>>(aug);
        }
        this.key = base.key();
        this._monitorId = base.getMonitorId();
        this._monitoredRouter = base.getMonitoredRouter();
        this._server = base.getServer();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServerConfig) {
            this._server = ((ServerConfig)arg).getServer();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.ServerConfig]");
    }

    public BmpMonitorConfigKey key() {
        return this.key;
    }

    public MonitorId getMonitorId() {
        return this._monitorId;
    }

    public List<MonitoredRouter> getMonitoredRouter() {
        return this._monitoredRouter;
    }

    public Server getServer() {
        return this._server;
    }

    public <E$$ extends Augmentation<BmpMonitorConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public BmpMonitorConfigBuilder withKey(BmpMonitorConfigKey key) {
        this.key = key;
        return this;
    }

    public BmpMonitorConfigBuilder setMonitorId(MonitorId value) {
        this._monitorId = value;
        return this;
    }

    public BmpMonitorConfigBuilder setMonitoredRouter(List<MonitoredRouter> values) {
        this._monitoredRouter = values;
        return this;
    }

    public BmpMonitorConfigBuilder setServer(Server value) {
        this._server = value;
        return this;
    }

    public BmpMonitorConfigBuilder addAugmentation(Class<? extends Augmentation<BmpMonitorConfig>> augmentationType, Augmentation<BmpMonitorConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BmpMonitorConfigBuilder removeAugmentation(Class<? extends Augmentation<BmpMonitorConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BmpMonitorConfig build() {
        return new BmpMonitorConfigImpl(this);
    }

    private static final class BmpMonitorConfigImpl
    extends AbstractAugmentable<BmpMonitorConfig>
    implements BmpMonitorConfig {
        private final MonitorId _monitorId;
        private final List<MonitoredRouter> _monitoredRouter;
        private final Server _server;
        private final BmpMonitorConfigKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BmpMonitorConfigImpl(BmpMonitorConfigBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new BmpMonitorConfigKey(base.getMonitorId());
            this._monitorId = this.key.getMonitorId();
            this._monitoredRouter = base.getMonitoredRouter();
            this._server = base.getServer();
        }

        @Override
        public BmpMonitorConfigKey key() {
            return this.key;
        }

        @Override
        public MonitorId getMonitorId() {
            return this._monitorId;
        }

        @Override
        public List<MonitoredRouter> getMonitoredRouter() {
            return this._monitoredRouter;
        }

        @Override
        public Server getServer() {
            return this._server;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitorId);
            result = 31 * result + Objects.hashCode(this._monitoredRouter);
            result = 31 * result + Objects.hashCode(this._server);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BmpMonitorConfig.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            BmpMonitorConfig other = (BmpMonitorConfig)obj;
            if (!Objects.equals(this._monitorId, other.getMonitorId())) {
                return false;
            }
            if (!Objects.equals(this._monitoredRouter, other.getMonitoredRouter())) {
                return false;
            }
            if (!Objects.equals(this._server, other.getServer())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BmpMonitorConfigImpl otherImpl = (BmpMonitorConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"BmpMonitorConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_monitorId", (Object)this._monitorId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_monitoredRouter", this._monitoredRouter);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_server", (Object)this._server);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

