/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.bmp.monitor.config;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.odl.bmp.monitors.bmp.monitor.config.MonitoredRouterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MonitoredRouterBuilder
implements Builder<MonitoredRouter> {
    private IpAddress _address;
    private Rfc2385Key _password;
    private PortNumber _port;
    private Boolean _active;
    private MonitoredRouterKey key;
    Map<Class<? extends Augmentation<MonitoredRouter>>, Augmentation<MonitoredRouter>> augmentation = Collections.emptyMap();

    public MonitoredRouterBuilder() {
    }

    public MonitoredRouterBuilder(MonitoredRouter base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitoredRouter>>, Augmentation<MonitoredRouter>>(aug);
        }
        this.key = base.key();
        this._address = base.getAddress();
        this._password = base.getPassword();
        this._port = base.getPort();
        this._active = base.isActive();
    }

    public MonitoredRouterKey key() {
        return this.key;
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public Rfc2385Key getPassword() {
        return this._password;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Boolean isActive() {
        return this._active;
    }

    public <E$$ extends Augmentation<MonitoredRouter>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MonitoredRouterBuilder withKey(MonitoredRouterKey key) {
        this.key = key;
        return this;
    }

    public MonitoredRouterBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public MonitoredRouterBuilder setPassword(Rfc2385Key value) {
        this._password = value;
        return this;
    }

    public MonitoredRouterBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public MonitoredRouterBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public MonitoredRouterBuilder addAugmentation(Class<? extends Augmentation<MonitoredRouter>> augmentationType, Augmentation<MonitoredRouter> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitoredRouter>>, Augmentation<MonitoredRouter>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MonitoredRouterBuilder removeAugmentation(Class<? extends Augmentation<MonitoredRouter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MonitoredRouter build() {
        return new MonitoredRouterImpl(this);
    }

    private static final class MonitoredRouterImpl
    extends AbstractAugmentable<MonitoredRouter>
    implements MonitoredRouter {
        private final IpAddress _address;
        private final Rfc2385Key _password;
        private final PortNumber _port;
        private final Boolean _active;
        private final MonitoredRouterKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MonitoredRouterImpl(MonitoredRouterBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new MonitoredRouterKey(base.getAddress());
            this._address = this.key.getAddress();
            this._password = base.getPassword();
            this._port = base.getPort();
            this._active = base.isActive();
        }

        @Override
        public MonitoredRouterKey key() {
            return this.key;
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public Rfc2385Key getPassword() {
            return this._password;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Boolean isActive() {
            return this._active;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._password);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._active);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MonitoredRouter.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MonitoredRouter other = (MonitoredRouter)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._password, other.getPassword())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._active, other.isActive())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MonitoredRouterImpl otherImpl = (MonitoredRouterImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MonitoredRouter");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_password", (Object)this._password);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_port", (Object)this._port);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_active", (Object)this._active);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

