/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.server.config;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev180329.server.config.Server;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServerBuilder
implements Builder<Server> {
    private IpAddress _bindingAddress;
    private PortNumber _bindingPort;
    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Collections.emptyMap();

    public ServerBuilder() {
    }

    public ServerBuilder(Server base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>(aug);
        }
        this._bindingAddress = base.getBindingAddress();
        this._bindingPort = base.getBindingPort();
    }

    public IpAddress getBindingAddress() {
        return this._bindingAddress;
    }

    public PortNumber getBindingPort() {
        return this._bindingPort;
    }

    public <E$$ extends Augmentation<Server>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ServerBuilder setBindingAddress(IpAddress value) {
        this._bindingAddress = value;
        return this;
    }

    public ServerBuilder setBindingPort(PortNumber value) {
        this._bindingPort = value;
        return this;
    }

    public ServerBuilder addAugmentation(Class<? extends Augmentation<Server>> augmentationType, Augmentation<Server> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
    extends AbstractAugmentable<Server>
    implements Server {
        private final IpAddress _bindingAddress;
        private final PortNumber _bindingPort;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServerImpl(ServerBuilder base) {
            super(base.augmentation);
            this._bindingAddress = base.getBindingAddress();
            this._bindingPort = base.getBindingPort();
        }

        @Override
        public IpAddress getBindingAddress() {
            return this._bindingAddress;
        }

        @Override
        public PortNumber getBindingPort() {
            return this._bindingPort;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bindingAddress);
            result = 31 * result + Objects.hashCode(this._bindingPort);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Server.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Server other = (Server)obj;
            if (!Objects.equals(this._bindingAddress, other.getBindingAddress())) {
                return false;
            }
            if (!Objects.equals(this._bindingPort, other.getBindingPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServerImpl otherImpl = (ServerImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Server");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bindingAddress", (Object)this._bindingAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bindingPort", (Object)this._bindingPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

