/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.bmp.monitor;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Routers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.bmp.monitor.Monitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.bmp.monitor.MonitorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.routers.Router;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MonitorBuilder
implements Builder<Monitor> {
    private MonitorId _monitorId;
    private List<Router> _router;
    private MonitorKey key;
    Map<Class<? extends Augmentation<Monitor>>, Augmentation<Monitor>> augmentation = Collections.emptyMap();

    public MonitorBuilder() {
    }

    public MonitorBuilder(Routers arg) {
        this._router = arg.getRouter();
    }

    public MonitorBuilder(Monitor base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Monitor>>, Augmentation<Monitor>>(aug);
        }
        this.key = base.key();
        this._monitorId = base.getMonitorId();
        this._router = base.getRouter();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Routers) {
            this._router = ((Routers)arg).getRouter();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Routers]");
    }

    public MonitorKey key() {
        return this.key;
    }

    public MonitorId getMonitorId() {
        return this._monitorId;
    }

    public List<Router> getRouter() {
        return this._router;
    }

    public <E$$ extends Augmentation<Monitor>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MonitorBuilder withKey(MonitorKey key) {
        this.key = key;
        return this;
    }

    public MonitorBuilder setMonitorId(MonitorId value) {
        this._monitorId = value;
        return this;
    }

    public MonitorBuilder setRouter(List<Router> values) {
        this._router = values;
        return this;
    }

    public MonitorBuilder addAugmentation(Class<? extends Augmentation<Monitor>> augmentationType, Augmentation<Monitor> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Monitor>>, Augmentation<Monitor>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MonitorBuilder removeAugmentation(Class<? extends Augmentation<Monitor>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Monitor build() {
        return new MonitorImpl(this);
    }

    private static final class MonitorImpl
    extends AbstractAugmentable<Monitor>
    implements Monitor {
        private final MonitorId _monitorId;
        private final List<Router> _router;
        private final MonitorKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MonitorImpl(MonitorBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new MonitorKey(base.getMonitorId());
            this._monitorId = this.key.getMonitorId();
            this._router = base.getRouter();
        }

        @Override
        public MonitorKey key() {
            return this.key;
        }

        @Override
        public MonitorId getMonitorId() {
            return this._monitorId;
        }

        @Override
        public List<Router> getRouter() {
            return this._router;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitorId);
            result = 31 * result + Objects.hashCode(this._router);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Monitor.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Monitor other = (Monitor)obj;
            if (!Objects.equals(this._monitorId, other.getMonitorId())) {
                return false;
            }
            if (!Objects.equals(this._router, other.getRouter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MonitorImpl otherImpl = (MonitorImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Monitor");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_monitorId", (Object)this._monitorId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_router", this._router);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

