/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.PeerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.Mirrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.PeerSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.PostPolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.PrePolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.Stats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerBuilder
implements Builder<Peer> {
    private IpAddress _address;
    private AsNumber _as;
    private Ipv4Address _bgpId;
    private Mirrors _mirrors;
    private Peer.PeerDistinguisher _peerDistinguisher;
    private PeerId _peerId;
    private PeerSession _peerSession;
    private PostPolicyRib _postPolicyRib;
    private PrePolicyRib _prePolicyRib;
    private String _routerDistinguisher;
    private Stats _stats;
    private PeerType _type;
    private PeerKey key;
    Map<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> augmentation = Collections.emptyMap();

    public PeerBuilder() {
    }

    public PeerBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer arg) {
        this._type = arg.getType();
        this._peerDistinguisher = arg.getPeerDistinguisher();
        this._address = arg.getAddress();
        this._as = arg.getAs();
        this._bgpId = arg.getBgpId();
    }

    public PeerBuilder(Peer base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Peer>>, Augmentation<Peer>>(aug);
        }
        this.key = base.key();
        this._peerId = base.getPeerId();
        this._address = base.getAddress();
        this._as = base.getAs();
        this._bgpId = base.getBgpId();
        this._mirrors = base.getMirrors();
        this._peerDistinguisher = base.getPeerDistinguisher();
        this._peerSession = base.getPeerSession();
        this._postPolicyRib = base.getPostPolicyRib();
        this._prePolicyRib = base.getPrePolicyRib();
        this._routerDistinguisher = base.getRouterDistinguisher();
        this._stats = base.getStats();
        this._type = base.getType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer) {
            this._type = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer)arg).getType();
            this._peerDistinguisher = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer)arg).getPeerDistinguisher();
            this._address = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer)arg).getAddress();
            this._as = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer)arg).getAs();
            this._bgpId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer)arg).getBgpId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Peer]");
    }

    public PeerKey key() {
        return this.key;
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public AsNumber getAs() {
        return this._as;
    }

    public Ipv4Address getBgpId() {
        return this._bgpId;
    }

    public Mirrors getMirrors() {
        return this._mirrors;
    }

    public Peer.PeerDistinguisher getPeerDistinguisher() {
        return this._peerDistinguisher;
    }

    public PeerId getPeerId() {
        return this._peerId;
    }

    public PeerSession getPeerSession() {
        return this._peerSession;
    }

    public PostPolicyRib getPostPolicyRib() {
        return this._postPolicyRib;
    }

    public PrePolicyRib getPrePolicyRib() {
        return this._prePolicyRib;
    }

    public String getRouterDistinguisher() {
        return this._routerDistinguisher;
    }

    public Stats getStats() {
        return this._stats;
    }

    public PeerType getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<Peer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PeerBuilder withKey(PeerKey key) {
        this.key = key;
        return this;
    }

    public PeerBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public PeerBuilder setAs(AsNumber value) {
        this._as = value;
        return this;
    }

    public PeerBuilder setBgpId(Ipv4Address value) {
        this._bgpId = value;
        return this;
    }

    public PeerBuilder setMirrors(Mirrors value) {
        this._mirrors = value;
        return this;
    }

    public PeerBuilder setPeerDistinguisher(Peer.PeerDistinguisher value) {
        this._peerDistinguisher = value;
        return this;
    }

    public PeerBuilder setPeerId(PeerId value) {
        this._peerId = value;
        return this;
    }

    public PeerBuilder setPeerSession(PeerSession value) {
        this._peerSession = value;
        return this;
    }

    public PeerBuilder setPostPolicyRib(PostPolicyRib value) {
        this._postPolicyRib = value;
        return this;
    }

    public PeerBuilder setPrePolicyRib(PrePolicyRib value) {
        this._prePolicyRib = value;
        return this;
    }

    public PeerBuilder setRouterDistinguisher(String value) {
        this._routerDistinguisher = value;
        return this;
    }

    public PeerBuilder setStats(Stats value) {
        this._stats = value;
        return this;
    }

    public PeerBuilder setType(PeerType value) {
        this._type = value;
        return this;
    }

    public PeerBuilder addAugmentation(Class<? extends Augmentation<Peer>> augmentationType, Augmentation<Peer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Peer>>, Augmentation<Peer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerBuilder removeAugmentation(Class<? extends Augmentation<Peer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Peer build() {
        return new PeerImpl(this);
    }

    private static final class PeerImpl
    extends AbstractAugmentable<Peer>
    implements Peer {
        private final IpAddress _address;
        private final AsNumber _as;
        private final Ipv4Address _bgpId;
        private final Mirrors _mirrors;
        private final Peer.PeerDistinguisher _peerDistinguisher;
        private final PeerId _peerId;
        private final PeerSession _peerSession;
        private final PostPolicyRib _postPolicyRib;
        private final PrePolicyRib _prePolicyRib;
        private final String _routerDistinguisher;
        private final Stats _stats;
        private final PeerType _type;
        private final PeerKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PeerImpl(PeerBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new PeerKey(base.getPeerId());
            this._peerId = this.key.getPeerId();
            this._address = base.getAddress();
            this._as = base.getAs();
            this._bgpId = base.getBgpId();
            this._mirrors = base.getMirrors();
            this._peerDistinguisher = base.getPeerDistinguisher();
            this._peerSession = base.getPeerSession();
            this._postPolicyRib = base.getPostPolicyRib();
            this._prePolicyRib = base.getPrePolicyRib();
            this._routerDistinguisher = base.getRouterDistinguisher();
            this._stats = base.getStats();
            this._type = base.getType();
        }

        @Override
        public PeerKey key() {
            return this.key;
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public AsNumber getAs() {
            return this._as;
        }

        @Override
        public Ipv4Address getBgpId() {
            return this._bgpId;
        }

        @Override
        public Mirrors getMirrors() {
            return this._mirrors;
        }

        @Override
        public Peer.PeerDistinguisher getPeerDistinguisher() {
            return this._peerDistinguisher;
        }

        @Override
        public PeerId getPeerId() {
            return this._peerId;
        }

        @Override
        public PeerSession getPeerSession() {
            return this._peerSession;
        }

        @Override
        public PostPolicyRib getPostPolicyRib() {
            return this._postPolicyRib;
        }

        @Override
        public PrePolicyRib getPrePolicyRib() {
            return this._prePolicyRib;
        }

        @Override
        public String getRouterDistinguisher() {
            return this._routerDistinguisher;
        }

        @Override
        public Stats getStats() {
            return this._stats;
        }

        @Override
        public PeerType getType() {
            return this._type;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._as);
            result = 31 * result + Objects.hashCode(this._bgpId);
            result = 31 * result + Objects.hashCode(this._mirrors);
            result = 31 * result + Objects.hashCode(this._peerDistinguisher);
            result = 31 * result + Objects.hashCode(this._peerId);
            result = 31 * result + Objects.hashCode(this._peerSession);
            result = 31 * result + Objects.hashCode(this._postPolicyRib);
            result = 31 * result + Objects.hashCode(this._prePolicyRib);
            result = 31 * result + Objects.hashCode(this._routerDistinguisher);
            result = 31 * result + Objects.hashCode(this._stats);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Peer.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Peer other = (Peer)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._as, other.getAs())) {
                return false;
            }
            if (!Objects.equals(this._bgpId, other.getBgpId())) {
                return false;
            }
            if (!Objects.equals(this._mirrors, other.getMirrors())) {
                return false;
            }
            if (!Objects.equals(this._peerDistinguisher, other.getPeerDistinguisher())) {
                return false;
            }
            if (!Objects.equals(this._peerId, other.getPeerId())) {
                return false;
            }
            if (!Objects.equals(this._peerSession, other.getPeerSession())) {
                return false;
            }
            if (!Objects.equals(this._postPolicyRib, other.getPostPolicyRib())) {
                return false;
            }
            if (!Objects.equals(this._prePolicyRib, other.getPrePolicyRib())) {
                return false;
            }
            if (!Objects.equals(this._routerDistinguisher, other.getRouterDistinguisher())) {
                return false;
            }
            if (!Objects.equals(this._stats, other.getStats())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerImpl otherImpl = (PeerImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Peer");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_as", (Object)this._as);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bgpId", (Object)this._bgpId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mirrors", (Object)this._mirrors);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerDistinguisher", (Object)this._peerDistinguisher);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerId", (Object)this._peerId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerSession", (Object)this._peerSession);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_postPolicyRib", (Object)this._postPolicyRib);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prePolicyRib", (Object)this._prePolicyRib);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routerDistinguisher", (Object)this._routerDistinguisher);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_stats", (Object)this._stats);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", (Object)((Object)this._type));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

