/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerUp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.up.SentOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Status;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.peer.PeerSession;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerSessionBuilder
implements Builder<PeerSession> {
    private Information _information;
    private IpAddress _localAddress;
    private PortNumber _localPort;
    private ReceivedOpen _receivedOpen;
    private PortNumber _remotePort;
    private SentOpen _sentOpen;
    private Status _status;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;
    Map<Class<? extends Augmentation<PeerSession>>, Augmentation<PeerSession>> augmentation = Collections.emptyMap();

    public PeerSessionBuilder() {
    }

    public PeerSessionBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public PeerSessionBuilder(PeerUp arg) {
        this._localAddress = arg.getLocalAddress();
        this._localPort = arg.getLocalPort();
        this._remotePort = arg.getRemotePort();
        this._sentOpen = arg.getSentOpen();
        this._receivedOpen = arg.getReceivedOpen();
        this._information = arg.getInformation();
    }

    public PeerSessionBuilder(PeerSession base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerSession>>, Augmentation<PeerSession>>(aug);
        }
        this._information = base.getInformation();
        this._localAddress = base.getLocalAddress();
        this._localPort = base.getLocalPort();
        this._receivedOpen = base.getReceivedOpen();
        this._remotePort = base.getRemotePort();
        this._sentOpen = base.getSentOpen();
        this._status = base.getStatus();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PeerUp) {
            this._localAddress = ((PeerUp)arg).getLocalAddress();
            this._localPort = ((PeerUp)arg).getLocalPort();
            this._remotePort = ((PeerUp)arg).getRemotePort();
            this._sentOpen = ((PeerUp)arg).getSentOpen();
            this._receivedOpen = ((PeerUp)arg).getReceivedOpen();
            this._information = ((PeerUp)arg).getInformation();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerUp, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Timestamp]");
    }

    public Information getInformation() {
        return this._information;
    }

    public IpAddress getLocalAddress() {
        return this._localAddress;
    }

    public PortNumber getLocalPort() {
        return this._localPort;
    }

    public ReceivedOpen getReceivedOpen() {
        return this._receivedOpen;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public SentOpen getSentOpen() {
        return this._sentOpen;
    }

    public Status getStatus() {
        return this._status;
    }

    public Timestamp getTimestampMicro() {
        return this._timestampMicro;
    }

    public Timestamp getTimestampSec() {
        return this._timestampSec;
    }

    public <E$$ extends Augmentation<PeerSession>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PeerSessionBuilder setInformation(Information value) {
        this._information = value;
        return this;
    }

    public PeerSessionBuilder setLocalAddress(IpAddress value) {
        this._localAddress = value;
        return this;
    }

    public PeerSessionBuilder setLocalPort(PortNumber value) {
        this._localPort = value;
        return this;
    }

    public PeerSessionBuilder setReceivedOpen(ReceivedOpen value) {
        this._receivedOpen = value;
        return this;
    }

    public PeerSessionBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public PeerSessionBuilder setSentOpen(SentOpen value) {
        this._sentOpen = value;
        return this;
    }

    public PeerSessionBuilder setStatus(Status value) {
        this._status = value;
        return this;
    }

    public PeerSessionBuilder setTimestampMicro(Timestamp value) {
        this._timestampMicro = value;
        return this;
    }

    public PeerSessionBuilder setTimestampSec(Timestamp value) {
        this._timestampSec = value;
        return this;
    }

    public PeerSessionBuilder addAugmentation(Class<? extends Augmentation<PeerSession>> augmentationType, Augmentation<PeerSession> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerSession>>, Augmentation<PeerSession>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerSessionBuilder removeAugmentation(Class<? extends Augmentation<PeerSession>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PeerSession build() {
        return new PeerSessionImpl(this);
    }

    private static final class PeerSessionImpl
    extends AbstractAugmentable<PeerSession>
    implements PeerSession {
        private final Information _information;
        private final IpAddress _localAddress;
        private final PortNumber _localPort;
        private final ReceivedOpen _receivedOpen;
        private final PortNumber _remotePort;
        private final SentOpen _sentOpen;
        private final Status _status;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PeerSessionImpl(PeerSessionBuilder base) {
            super(base.augmentation);
            this._information = base.getInformation();
            this._localAddress = base.getLocalAddress();
            this._localPort = base.getLocalPort();
            this._receivedOpen = base.getReceivedOpen();
            this._remotePort = base.getRemotePort();
            this._sentOpen = base.getSentOpen();
            this._status = base.getStatus();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
        }

        @Override
        public Information getInformation() {
            return this._information;
        }

        @Override
        public IpAddress getLocalAddress() {
            return this._localAddress;
        }

        @Override
        public PortNumber getLocalPort() {
            return this._localPort;
        }

        @Override
        public ReceivedOpen getReceivedOpen() {
            return this._receivedOpen;
        }

        @Override
        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        @Override
        public SentOpen getSentOpen() {
            return this._sentOpen;
        }

        @Override
        public Status getStatus() {
            return this._status;
        }

        @Override
        public Timestamp getTimestampMicro() {
            return this._timestampMicro;
        }

        @Override
        public Timestamp getTimestampSec() {
            return this._timestampSec;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._information);
            result = 31 * result + Objects.hashCode(this._localAddress);
            result = 31 * result + Objects.hashCode(this._localPort);
            result = 31 * result + Objects.hashCode(this._receivedOpen);
            result = 31 * result + Objects.hashCode(this._remotePort);
            result = 31 * result + Objects.hashCode(this._sentOpen);
            result = 31 * result + Objects.hashCode((Object)this._status);
            result = 31 * result + Objects.hashCode(this._timestampMicro);
            result = 31 * result + Objects.hashCode(this._timestampSec);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerSession.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerSession other = (PeerSession)obj;
            if (!Objects.equals(this._information, other.getInformation())) {
                return false;
            }
            if (!Objects.equals(this._localAddress, other.getLocalAddress())) {
                return false;
            }
            if (!Objects.equals(this._localPort, other.getLocalPort())) {
                return false;
            }
            if (!Objects.equals(this._receivedOpen, other.getReceivedOpen())) {
                return false;
            }
            if (!Objects.equals(this._remotePort, other.getRemotePort())) {
                return false;
            }
            if (!Objects.equals(this._sentOpen, other.getSentOpen())) {
                return false;
            }
            if (!Objects.equals((Object)this._status, (Object)other.getStatus())) {
                return false;
            }
            if (!Objects.equals(this._timestampMicro, other.getTimestampMicro())) {
                return false;
            }
            if (!Objects.equals(this._timestampSec, other.getTimestampSec())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerSessionImpl otherImpl = (PeerSessionImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PeerSession");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_information", (Object)this._information);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localAddress", (Object)this._localAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localPort", (Object)this._localPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_receivedOpen", (Object)this._receivedOpen);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_remotePort", (Object)this._remotePort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sentOpen", (Object)this._sentOpen);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_status", (Object)((Object)this._status));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timestampMicro", (Object)this._timestampMicro);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timestampSec", (Object)this._timestampSec);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

