/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.routers;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Peers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Status;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.routers.Router;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.routers.RouterKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RouterBuilder
implements Builder<Router> {
    private String _description;
    private String _info;
    private String _name;
    private List<Peer> _peer;
    private RouterId _routerId;
    private Status _status;
    private RouterKey key;
    Map<Class<? extends Augmentation<Router>>, Augmentation<Router>> augmentation = Collections.emptyMap();

    public RouterBuilder() {
    }

    public RouterBuilder(Peers arg) {
        this._peer = arg.getPeer();
    }

    public RouterBuilder(Router base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Router>>, Augmentation<Router>>(aug);
        }
        this.key = base.key();
        this._routerId = base.getRouterId();
        this._description = base.getDescription();
        this._info = base.getInfo();
        this._name = base.getName();
        this._peer = base.getPeer();
        this._status = base.getStatus();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peers) {
            this._peer = ((Peers)arg).getPeer();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev180329.Peers]");
    }

    public RouterKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public String getInfo() {
        return this._info;
    }

    public String getName() {
        return this._name;
    }

    public List<Peer> getPeer() {
        return this._peer;
    }

    public RouterId getRouterId() {
        return this._routerId;
    }

    public Status getStatus() {
        return this._status;
    }

    public <E$$ extends Augmentation<Router>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RouterBuilder withKey(RouterKey key) {
        this.key = key;
        return this;
    }

    public RouterBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public RouterBuilder setInfo(String value) {
        this._info = value;
        return this;
    }

    public RouterBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public RouterBuilder setPeer(List<Peer> values) {
        this._peer = values;
        return this;
    }

    public RouterBuilder setRouterId(RouterId value) {
        this._routerId = value;
        return this;
    }

    public RouterBuilder setStatus(Status value) {
        this._status = value;
        return this;
    }

    public RouterBuilder addAugmentation(Class<? extends Augmentation<Router>> augmentationType, Augmentation<Router> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Router>>, Augmentation<Router>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RouterBuilder removeAugmentation(Class<? extends Augmentation<Router>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Router build() {
        return new RouterImpl(this);
    }

    private static final class RouterImpl
    extends AbstractAugmentable<Router>
    implements Router {
        private final String _description;
        private final String _info;
        private final String _name;
        private final List<Peer> _peer;
        private final RouterId _routerId;
        private final Status _status;
        private final RouterKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RouterImpl(RouterBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new RouterKey(base.getRouterId());
            this._routerId = this.key.getRouterId();
            this._description = base.getDescription();
            this._info = base.getInfo();
            this._name = base.getName();
            this._peer = base.getPeer();
            this._status = base.getStatus();
        }

        @Override
        public RouterKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getInfo() {
            return this._info;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<Peer> getPeer() {
            return this._peer;
        }

        @Override
        public RouterId getRouterId() {
            return this._routerId;
        }

        @Override
        public Status getStatus() {
            return this._status;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._info);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._peer);
            result = 31 * result + Objects.hashCode(this._routerId);
            result = 31 * result + Objects.hashCode((Object)this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Router.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Router other = (Router)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._info, other.getInfo())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._peer, other.getPeer())) {
                return false;
            }
            if (!Objects.equals(this._routerId, other.getRouterId())) {
                return false;
            }
            if (!Objects.equals((Object)this._status, (Object)other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RouterImpl otherImpl = (RouterImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Router");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_info", (Object)this._info);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peer", this._peer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routerId", (Object)this._routerId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_status", (Object)((Object)this._status));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

