package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping afi-safi-gauge-tlv {
 *   uses tlv;
 *   uses bgp-mp:bgp-table-type;
 *   leaf count {
 *     type yang:gauge64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/afi-safi-gauge-tlv</i>
 *
 */
public interface AfiSafiGaugeTlv
    extends
    DataObject,
    Tlv,
    BgpTableType
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("afi-safi-gauge-tlv");

    @Override
    Class<? extends AfiSafiGaugeTlv> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64</code> <code>count</code>, or <code>null</code> if not present
     */
    @Nullable Gauge64 getCount();

}

