package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>bmp-message</b>
 * <pre>
 * notification initiation-message {
 *   uses initiation;
 * }
 * notification termination-message {
 *   uses termination;
 * }
 * notification route-monitoring-message {
 *   uses peer-header;
 *   container update {
 *     uses bgp-msg:update-message;
 *   }
 * }
 * notification route-mirroring-message {
 *   uses peer-header;
 *   uses mirror;
 * }
 * notification stats-reports-message {
 *   uses peer-header;
 *   uses stat;
 * }
 * notification peer-down-notification {
 *   uses peer-header;
 *   uses peer-down;
 * }
 * notification peer-up-notification {
 *   uses peer-header;
 *   uses peer-up;
 * }
 * </pre>
 *
 */
public interface BmpMessageListener
    extends
    NotificationListener
{




    /**
     * The initiation message provides a means for the monitored router to inform the
     * monitoring station of its vendor, software version, and so on.
     *
     */
    void onInitiationMessage(InitiationMessage notification);
    
    /**
     * The termination message provides a way for a monitored router to indicate why it
     * is terminating a session.
     *
     */
    void onTerminationMessage(TerminationMessage notification);
    
    /**
     * Route Monitoring messages are used for initial synchronization of ADJ-RIBs-In.
     * They are also used for ongoing monitoring of received advertisements and
     * withdraws.
     *
     */
    void onRouteMonitoringMessage(RouteMonitoringMessage notification);
    
    /**
     * Route Mirroring messages are used for verbatim duplication of messages as
     * received.
     *
     */
    void onRouteMirroringMessage(RouteMirroringMessage notification);
    
    /**
     * These messages contain information that could be used by the monitoring station
     * to observe interesting events that occur on the router.
     *
     */
    void onStatsReportsMessage(StatsReportsMessage notification);
    
    /**
     * This message is used to indicate that a peering session was terminated.
     *
     */
    void onPeerDownNotification(PeerDownNotification notification);
    
    /**
     * The Peer Up message is used to indicate that a peering session has come up
     * (i.e., has transitioned into ESTABLISHED state).
     *
     */
    void onPeerUpNotification(PeerUpNotification notification);

}

