package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping description-tlv {
 *   container description-tlv {
 *     uses tlv;
 *     leaf description {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/description-tlv</i>
 *
 */
public interface DescriptionTlv
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("description-tlv");

    @Override
    Class<? extends DescriptionTlv> implementedInterface();
    
    /**
     * Type = 1: sysDescr. The Information field contains an ASCII string whose value
     * MUST be set to be equal to the value of the sysDescr MIB-II [RFC1213] object.
     * Inclusion of this TLV is mandatory.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv</code> <code>descriptionTlv</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.@Nullable DescriptionTlv getDescriptionTlv();

}

