package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The initiation message provides a means for the monitored router to inform the 
 * monitoring station of its vendor, software version, and so on.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification initiation-message {
 *   uses initiation;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/initiation-message</i>
 *
 * <p>To create instances of this class use {@link InitiationMessageBuilder}.
 * @see InitiationMessageBuilder
 *
 */
public interface InitiationMessage
    extends
    DataObject,
    Augmentable<InitiationMessage>,
    Initiation,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("initiation-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage.class;
    }

}

