package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * TLVs containing information about the monitored router
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping initiation-tlvs {
 *   uses string-informations;
 *   uses description-tlv;
 *   uses name-tlv;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/initiation-tlvs</i>
 *
 */
public interface InitiationTlvs
    extends
    DataObject,
    StringInformations,
    DescriptionTlv,
    NameTlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("initiation-tlvs");

    @Override
    Class<? extends InitiationTlvs> implementedInterface();

}

