package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping mirror-information-tlv {
 *   container mirror-information-tlv {
 *     uses tlv;
 *     leaf code {
 *       type mirror-information-code;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/mirror-information-tlv</i>
 *
 */
public interface MirrorInformationTlv
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mirror-information-tlv");

    @Override
    Class<? extends MirrorInformationTlv> implementedInterface();
    
    /**
     * Type = 1: Information. A two-byte code that provides information about the
     * mirrored message or message stream.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.information.tlv.MirrorInformationTlv</code> <code>mirrorInformationTlv</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.information.tlv.@Nullable MirrorInformationTlv getMirrorInformationTlv();

}

