package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduUpdateTlv;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * BGP Message. A BGP PDU. This PDU may or may not be an Update message. If the 
 * Message TLV occurs in the Route Mirroring message, it MUST occur last in the 
 * list of TLVs.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping mirror-pdu-tlvs {
 *   container pdu-update-tlv {
 *     uses tlv;
 *     uses bgp-msg:update-message;
 *   }
 *   container pdu-open-tlv {
 *     uses tlv;
 *     uses bgp-msg:open-message;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/mirror-pdu-tlvs</i>
 *
 */
public interface MirrorPduTlvs
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mirror-pdu-tlvs");

    @Override
    Class<? extends MirrorPduTlvs> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduUpdateTlv</code> <code>pduUpdateTlv</code>, or <code>null</code> if not present
     */
    @Nullable PduUpdateTlv getPduUpdateTlv();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv</code> <code>pduOpenTlv</code>, or <code>null</code> if not present
     */
    @Nullable PduOpenTlv getPduOpenTlv();

}

