package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping name-tlv {
 *   container name-tlv {
 *     uses tlv;
 *     leaf name {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/name-tlv</i>
 *
 */
public interface NameTlv
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("name-tlv");

    @Override
    Class<? extends NameTlv> implementedInterface();
    
    /**
     * Type = 2: sysName. The Information field contains a ASCII string whose value
     * MUST be set to be equal to the value of the sysName MIB-II [RFC1213] object.
     * Inclusion of this TLV is mandatory.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.NameTlv</code> <code>nameTlv</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.@Nullable NameTlv getNameTlv();

}

