package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisher;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer {
 *   leaf type {
 *     type peer-type;
 *   }
 *   leaf peer-distinguisher {
 *     type union {
 *       type bgp-t:route-distinguisher;
 *       type binary {
 *         length 8;
 *       }
 *     }
 *   }
 *   leaf address {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf as {
 *     type inet:as-number;
 *   }
 *   leaf bgp-id {
 *     type inet:ipv4-address-no-zone;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer</i>
 *
 */
public interface Peer
    extends
    DataObject
{

    public static final class PeerDistinguisher
     implements TypeObject {
        private final RouteDistinguisher _routeDistinguisher;
        private final byte[] _binary;
    
    
        public PeerDistinguisher(RouteDistinguisher _routeDistinguisher) {
            super();
            this._routeDistinguisher = _routeDistinguisher;
            this._binary = null;
        }
        
        private static void check_binaryLength(final byte[] value) {
            final int length = value.length;
            if (length == 8) {
                return;
            }
            CodeHelpers.throwInvalidLength("[[8..8]]", value);
        }
        public PeerDistinguisher(byte[] _binary) {
            super();
            check_binaryLength(_binary);
            
            this._binary = _binary;
            this._routeDistinguisher = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public PeerDistinguisher(PeerDistinguisher source) {
            this._routeDistinguisher = source._routeDistinguisher;
            this._binary = source._binary == null ? null : source._binary.clone();
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_routeDistinguisher != null) {
                return _routeDistinguisher.stringValue();
            }
            if (_binary != null) {
                return new String(_binary);
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public RouteDistinguisher getRouteDistinguisher() {
            return _routeDistinguisher;
        }
        
        public byte[] getBinary() {
            return _binary == null ? null : _binary.clone();
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_routeDistinguisher);
            result = prime * result + Arrays.hashCode(_binary);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PeerDistinguisher)) {
                return false;
            }
            final PeerDistinguisher other = (PeerDistinguisher) obj;
            if (!Objects.equals(_routeDistinguisher, other._routeDistinguisher)) {
                return false;
            }
            if (!Arrays.equals(_binary, other._binary)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PeerDistinguisher.class);
            CodeHelpers.appendValue(helper, "_routeDistinguisher", _routeDistinguisher);
            CodeHelpers.appendValue(helper, "_binary", _binary);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer");

    @Override
    Class<? extends Peer> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerType</code> <code>type</code>, or <code>null</code> if not present
     */
    @Nullable PeerType getType();
    
    /**
     * This field is present to distinguish peers that belong to one address domain
     * from the other.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher</code> <code>peerDistinguisher</code>, or <code>null</code> if not present
     */
    @Nullable PeerDistinguisher getPeerDistinguisher();
    
    /**
     * The remote IP address associated with the TCP session over which the
     * encapsulated PDU was received. It is 4 bytes long if an IPv4 address is carried
     * in this field (with most significant bytes zero filled) and 16 bytes long if an
     * IPv6 address is carried in this field.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone</code> <code>address</code>, or <code>null</code> if not present
     */
    @Nullable IpAddressNoZone getAddress();
    
    /**
     * The Autonomous System number of the peer from which the encapsulated PDU was
     * received. If a 16 bit AS number is stored in this field [RFC4893], it should be
     * padded with zeroes in the most significant bits.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber</code> <code>as</code>, or <code>null</code> if not present
     */
    @Nullable AsNumber getAs();
    
    /**
     * The BGP Identifier of the peer from which the encapsulated PDU was received.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone</code> <code>bgpId</code>, or <code>null</code> if not present
     */
    @Nullable Ipv4AddressNoZone getBgpId();

}

