package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer-down {
 *   leaf local-system-closed {
 *     type boolean;
 *   }
 *   choice data {
 *     case notification {
 *       container notification {
 *         uses bgp-msg:notify-message;
 *       }
 *     }
 *     case fsm-event-code {
 *       leaf fsm-event-code {
 *         type uint16;
 *         default 0;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-down</i>
 *
 */
public interface PeerDown
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-down");

    @Override
    Class<? extends PeerDown> implementedInterface();
    
    /**
     * If set true, the local system closed the session. Otherwise the remote system
     * closed the session.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>localSystemClosed</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isLocalSystemClosed();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data</code> <code>data</code>, or <code>null</code> if not present
     */
    @Nullable Data getData();

}

