package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * This message is used to indicate that a peering session was terminated.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification peer-down-notification {
 *   uses peer-header;
 *   uses peer-down;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-down-notification</i>
 *
 * <p>To create instances of this class use {@link PeerDownNotificationBuilder}.
 * @see PeerDownNotificationBuilder
 *
 */
public interface PeerDownNotification
    extends
    DataObject,
    Augmentable<PeerDownNotification>,
    PeerHeader,
    PeerDown,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-down-notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification.class;
    }

}

