package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerDownNotificationBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerDownNotificationBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerDownNotificationBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerDownNotificationBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerDownNotificationBuilder
 * @see Builder
 *
 */
public class PeerDownNotificationBuilder implements Builder<PeerDownNotification> {

    private Data _data;
    private PeerHeader _peerHeader;
    private Boolean _localSystemClosed;


    Map<Class<? extends Augmentation<PeerDownNotification>>, Augmentation<PeerDownNotification>> augmentation = Collections.emptyMap();

    public PeerDownNotificationBuilder() {
    }
    public PeerDownNotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader arg) {
        this._peerHeader = arg.getPeerHeader();
    }
    public PeerDownNotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown arg) {
        this._localSystemClosed = arg.isLocalSystemClosed();
        this._data = arg.getData();
    }

    public PeerDownNotificationBuilder(PeerDownNotification base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<PeerDownNotification>>, Augmentation<PeerDownNotification>> aug =((AugmentationHolder<PeerDownNotification>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._data = base.getData();
        this._peerHeader = base.getPeerHeader();
        this._localSystemClosed = base.isLocalSystemClosed();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown) {
            this._localSystemClosed = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown)arg).isLocalSystemClosed();
            this._data = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader) {
            this._peerHeader = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader)arg).getPeerHeader();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader]");
    }

    public Data getData() {
        return _data;
    }
    
    public PeerHeader getPeerHeader() {
        return _peerHeader;
    }
    
    public Boolean isLocalSystemClosed() {
        return _localSystemClosed;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerDownNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public PeerDownNotificationBuilder setData(final Data value) {
        this._data = value;
        return this;
    }
    
    public PeerDownNotificationBuilder setPeerHeader(final PeerHeader value) {
        this._peerHeader = value;
        return this;
    }
    
    public PeerDownNotificationBuilder setLocalSystemClosed(final Boolean value) {
        this._localSystemClosed = value;
        return this;
    }
    
    public PeerDownNotificationBuilder addAugmentation(Class<? extends Augmentation<PeerDownNotification>> augmentationType, Augmentation<PeerDownNotification> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PeerDownNotificationBuilder removeAugmentation(Class<? extends Augmentation<PeerDownNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerDownNotification build() {
        return new PeerDownNotificationImpl(this);
    }

    private static final class PeerDownNotificationImpl
        extends AbstractAugmentable<PeerDownNotification>
        implements PeerDownNotification {
    
        private final Data _data;
        private final PeerHeader _peerHeader;
        private final Boolean _localSystemClosed;
    
        PeerDownNotificationImpl(PeerDownNotificationBuilder base) {
            super(base.augmentation);
            this._data = base.getData();
            this._peerHeader = base.getPeerHeader();
            this._localSystemClosed = base.isLocalSystemClosed();
        }
    
        @Override
        public Data getData() {
            return _data;
        }
        
        @Override
        public PeerHeader getPeerHeader() {
            return _peerHeader;
        }
        
        @Override
        public Boolean isLocalSystemClosed() {
            return _localSystemClosed;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_data);
            result = prime * result + Objects.hashCode(_peerHeader);
            result = prime * result + Objects.hashCode(_localSystemClosed);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerDownNotification.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerDownNotification other = (PeerDownNotification)obj;
            if (!Objects.equals(_data, other.getData())) {
                return false;
            }
            if (!Objects.equals(_peerHeader, other.getPeerHeader())) {
                return false;
            }
            if (!Objects.equals(_localSystemClosed, other.isLocalSystemClosed())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PeerDownNotificationImpl otherImpl = (PeerDownNotificationImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PeerDownNotification>>, Augmentation<PeerDownNotification>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerDownNotification");
            CodeHelpers.appendValue(helper, "_data", _data);
            CodeHelpers.appendValue(helper, "_peerHeader", _peerHeader);
            CodeHelpers.appendValue(helper, "_localSystemClosed", _localSystemClosed);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
