package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer-up {
 *   leaf local-address {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf local-port {
 *     type inet:port-number;
 *   }
 *   leaf remote-port {
 *     type inet:port-number;
 *   }
 *   container sent-open {
 *     uses open-msg;
 *   }
 *   container received-open {
 *     uses open-msg;
 *   }
 *   container information {
 *     uses string-informations;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up</i>
 *
 */
public interface PeerUp
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-up");

    @Override
    Class<? extends PeerUp> implementedInterface();
    
    /**
     * The local IP address associated with the peering TCP session.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone</code> <code>localAddress</code>, or <code>null</code> if not present
     */
    @Nullable IpAddressNoZone getLocalAddress();
    
    /**
     * The local port number associated with the peering TCP session.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>localPort</code>, or <code>null</code> if not present
     */
    @Nullable PortNumber getLocalPort();
    
    /**
     * The remote port number associated with the peering TCP session.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>remotePort</code>, or <code>null</code> if not present
     */
    @Nullable PortNumber getRemotePort();
    
    /**
     * The full OPEN message transmitted by the monitored router to its peer.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen</code> <code>sentOpen</code>, or <code>null</code> if not present
     */
    @Nullable SentOpen getSentOpen();
    
    /**
     * The full OPEN message received by the monitored router from its peer.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen</code> <code>receivedOpen</code>, or <code>null</code> if not present
     */
    @Nullable ReceivedOpen getReceivedOpen();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information</code> <code>information</code>, or <code>null</code> if not present
     */
    @Nullable Information getInformation();

}

