package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The Peer Up message is used to indicate that a peering session has come up 
 * (i.e., has transitioned into ESTABLISHED state).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification peer-up-notification {
 *   uses peer-header;
 *   uses peer-up;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up-notification</i>
 *
 * <p>To create instances of this class use {@link PeerUpNotificationBuilder}.
 * @see PeerUpNotificationBuilder
 *
 */
public interface PeerUpNotification
    extends
    DataObject,
    Augmentable<PeerUpNotification>,
    PeerHeader,
    PeerUp,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-up-notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification.class;
    }

}

