package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerUpNotificationBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerUpNotificationBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerUpNotificationBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerUpNotificationBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerUpNotificationBuilder
 * @see Builder
 *
 */
public class PeerUpNotificationBuilder implements Builder<PeerUpNotification> {

    private Information _information;
    private IpAddressNoZone _localAddress;
    private PortNumber _localPort;
    private PeerHeader _peerHeader;
    private ReceivedOpen _receivedOpen;
    private PortNumber _remotePort;
    private SentOpen _sentOpen;


    Map<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>> augmentation = Collections.emptyMap();

    public PeerUpNotificationBuilder() {
    }
    public PeerUpNotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader arg) {
        this._peerHeader = arg.getPeerHeader();
    }
    public PeerUpNotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp arg) {
        this._localAddress = arg.getLocalAddress();
        this._localPort = arg.getLocalPort();
        this._remotePort = arg.getRemotePort();
        this._sentOpen = arg.getSentOpen();
        this._receivedOpen = arg.getReceivedOpen();
        this._information = arg.getInformation();
    }

    public PeerUpNotificationBuilder(PeerUpNotification base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>> aug =((AugmentationHolder<PeerUpNotification>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._information = base.getInformation();
        this._localAddress = base.getLocalAddress();
        this._localPort = base.getLocalPort();
        this._peerHeader = base.getPeerHeader();
        this._receivedOpen = base.getReceivedOpen();
        this._remotePort = base.getRemotePort();
        this._sentOpen = base.getSentOpen();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp) {
            this._localAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getLocalAddress();
            this._localPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getLocalPort();
            this._remotePort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getRemotePort();
            this._sentOpen = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getSentOpen();
            this._receivedOpen = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getReceivedOpen();
            this._information = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp)arg).getInformation();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader) {
            this._peerHeader = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader)arg).getPeerHeader();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader]");
    }

    public Information getInformation() {
        return _information;
    }
    
    public IpAddressNoZone getLocalAddress() {
        return _localAddress;
    }
    
    public PortNumber getLocalPort() {
        return _localPort;
    }
    
    public PeerHeader getPeerHeader() {
        return _peerHeader;
    }
    
    public ReceivedOpen getReceivedOpen() {
        return _receivedOpen;
    }
    
    public PortNumber getRemotePort() {
        return _remotePort;
    }
    
    public SentOpen getSentOpen() {
        return _sentOpen;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerUpNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public PeerUpNotificationBuilder setInformation(final Information value) {
        this._information = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setLocalAddress(final IpAddressNoZone value) {
        this._localAddress = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setLocalPort(final PortNumber value) {
        this._localPort = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setPeerHeader(final PeerHeader value) {
        this._peerHeader = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setReceivedOpen(final ReceivedOpen value) {
        this._receivedOpen = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setRemotePort(final PortNumber value) {
        this._remotePort = value;
        return this;
    }
    
    public PeerUpNotificationBuilder setSentOpen(final SentOpen value) {
        this._sentOpen = value;
        return this;
    }
    
    public PeerUpNotificationBuilder addAugmentation(Class<? extends Augmentation<PeerUpNotification>> augmentationType, Augmentation<PeerUpNotification> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PeerUpNotificationBuilder removeAugmentation(Class<? extends Augmentation<PeerUpNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerUpNotification build() {
        return new PeerUpNotificationImpl(this);
    }

    private static final class PeerUpNotificationImpl
        extends AbstractAugmentable<PeerUpNotification>
        implements PeerUpNotification {
    
        private final Information _information;
        private final IpAddressNoZone _localAddress;
        private final PortNumber _localPort;
        private final PeerHeader _peerHeader;
        private final ReceivedOpen _receivedOpen;
        private final PortNumber _remotePort;
        private final SentOpen _sentOpen;
    
        PeerUpNotificationImpl(PeerUpNotificationBuilder base) {
            super(base.augmentation);
            this._information = base.getInformation();
            this._localAddress = base.getLocalAddress();
            this._localPort = base.getLocalPort();
            this._peerHeader = base.getPeerHeader();
            this._receivedOpen = base.getReceivedOpen();
            this._remotePort = base.getRemotePort();
            this._sentOpen = base.getSentOpen();
        }
    
        @Override
        public Information getInformation() {
            return _information;
        }
        
        @Override
        public IpAddressNoZone getLocalAddress() {
            return _localAddress;
        }
        
        @Override
        public PortNumber getLocalPort() {
            return _localPort;
        }
        
        @Override
        public PeerHeader getPeerHeader() {
            return _peerHeader;
        }
        
        @Override
        public ReceivedOpen getReceivedOpen() {
            return _receivedOpen;
        }
        
        @Override
        public PortNumber getRemotePort() {
            return _remotePort;
        }
        
        @Override
        public SentOpen getSentOpen() {
            return _sentOpen;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_information);
            result = prime * result + Objects.hashCode(_localAddress);
            result = prime * result + Objects.hashCode(_localPort);
            result = prime * result + Objects.hashCode(_peerHeader);
            result = prime * result + Objects.hashCode(_receivedOpen);
            result = prime * result + Objects.hashCode(_remotePort);
            result = prime * result + Objects.hashCode(_sentOpen);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerUpNotification.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerUpNotification other = (PeerUpNotification)obj;
            if (!Objects.equals(_information, other.getInformation())) {
                return false;
            }
            if (!Objects.equals(_localAddress, other.getLocalAddress())) {
                return false;
            }
            if (!Objects.equals(_localPort, other.getLocalPort())) {
                return false;
            }
            if (!Objects.equals(_peerHeader, other.getPeerHeader())) {
                return false;
            }
            if (!Objects.equals(_receivedOpen, other.getReceivedOpen())) {
                return false;
            }
            if (!Objects.equals(_remotePort, other.getRemotePort())) {
                return false;
            }
            if (!Objects.equals(_sentOpen, other.getSentOpen())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PeerUpNotificationImpl otherImpl = (PeerUpNotificationImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PeerUpNotification>>, Augmentation<PeerUpNotification>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerUpNotification");
            CodeHelpers.appendValue(helper, "_information", _information);
            CodeHelpers.appendValue(helper, "_localAddress", _localAddress);
            CodeHelpers.appendValue(helper, "_localPort", _localPort);
            CodeHelpers.appendValue(helper, "_peerHeader", _peerHeader);
            CodeHelpers.appendValue(helper, "_receivedOpen", _receivedOpen);
            CodeHelpers.appendValue(helper, "_remotePort", _remotePort);
            CodeHelpers.appendValue(helper, "_sentOpen", _sentOpen);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
