package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Route Mirroring messages are used for verbatim duplication of messages as 
 * received.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification route-mirroring-message {
 *   uses peer-header;
 *   uses mirror;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/route-mirroring-message</i>
 *
 * <p>To create instances of this class use {@link RouteMirroringMessageBuilder}.
 * @see RouteMirroringMessageBuilder
 *
 */
public interface RouteMirroringMessage
    extends
    DataObject,
    Augmentable<RouteMirroringMessage>,
    PeerHeader,
    Mirror,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("route-mirroring-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessage.class;
    }

}

