package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.Update;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Route Monitoring messages are used for initial synchronization of ADJ-RIBs-In. 
 * They are also used for ongoing monitoring of received advertisements and 
 * withdraws.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification route-monitoring-message {
 *   uses peer-header;
 *   container update {
 *     uses bgp-msg:update-message;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/route-monitoring-message</i>
 *
 * <p>To create instances of this class use {@link RouteMonitoringMessageBuilder}.
 * @see RouteMonitoringMessageBuilder
 *
 */
public interface RouteMonitoringMessage
    extends
    DataObject,
    Augmentable<RouteMonitoringMessage>,
    PeerHeader,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("route-monitoring-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.Update</code> <code>update</code>, or <code>null</code> if not present
     */
    @Nullable Update getUpdate();

}

