package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.Update;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RouteMonitoringMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RouteMonitoringMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RouteMonitoringMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RouteMonitoringMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RouteMonitoringMessageBuilder
 * @see Builder
 *
 */
public class RouteMonitoringMessageBuilder implements Builder<RouteMonitoringMessage> {

    private PeerHeader _peerHeader;
    private Update _update;


    Map<Class<? extends Augmentation<RouteMonitoringMessage>>, Augmentation<RouteMonitoringMessage>> augmentation = Collections.emptyMap();

    public RouteMonitoringMessageBuilder() {
    }
    public RouteMonitoringMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader arg) {
        this._peerHeader = arg.getPeerHeader();
    }

    public RouteMonitoringMessageBuilder(RouteMonitoringMessage base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RouteMonitoringMessage>>, Augmentation<RouteMonitoringMessage>> aug =((AugmentationHolder<RouteMonitoringMessage>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._peerHeader = base.getPeerHeader();
        this._update = base.getUpdate();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader) {
            this._peerHeader = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader)arg).getPeerHeader();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader]");
    }

    public PeerHeader getPeerHeader() {
        return _peerHeader;
    }
    
    public Update getUpdate() {
        return _update;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RouteMonitoringMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RouteMonitoringMessageBuilder setPeerHeader(final PeerHeader value) {
        this._peerHeader = value;
        return this;
    }
    
    public RouteMonitoringMessageBuilder setUpdate(final Update value) {
        this._update = value;
        return this;
    }
    
    public RouteMonitoringMessageBuilder addAugmentation(Class<? extends Augmentation<RouteMonitoringMessage>> augmentationType, Augmentation<RouteMonitoringMessage> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RouteMonitoringMessageBuilder removeAugmentation(Class<? extends Augmentation<RouteMonitoringMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RouteMonitoringMessage build() {
        return new RouteMonitoringMessageImpl(this);
    }

    private static final class RouteMonitoringMessageImpl
        extends AbstractAugmentable<RouteMonitoringMessage>
        implements RouteMonitoringMessage {
    
        private final PeerHeader _peerHeader;
        private final Update _update;
    
        RouteMonitoringMessageImpl(RouteMonitoringMessageBuilder base) {
            super(base.augmentation);
            this._peerHeader = base.getPeerHeader();
            this._update = base.getUpdate();
        }
    
        @Override
        public PeerHeader getPeerHeader() {
            return _peerHeader;
        }
        
        @Override
        public Update getUpdate() {
            return _update;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_peerHeader);
            result = prime * result + Objects.hashCode(_update);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RouteMonitoringMessage.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RouteMonitoringMessage other = (RouteMonitoringMessage)obj;
            if (!Objects.equals(_peerHeader, other.getPeerHeader())) {
                return false;
            }
            if (!Objects.equals(_update, other.getUpdate())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RouteMonitoringMessageImpl otherImpl = (RouteMonitoringMessageImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RouteMonitoringMessage>>, Augmentation<RouteMonitoringMessage>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RouteMonitoringMessage");
            CodeHelpers.appendValue(helper, "_peerHeader", _peerHeader);
            CodeHelpers.appendValue(helper, "_update", _update);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
