package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Each counter is encoded as a TLV.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping stat-tlvs {
 *   container rejected-prefixes-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-prefix-advertisements-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-withdraws-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-cluster-list-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-as-path-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-originator-id-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-as-confed-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container adj-ribs-in-routes-tlv {
 *     uses gauge-tlv;
 *   }
 *   container loc-rib-routes-tlv {
 *     uses gauge-tlv;
 *   }
 *   container per-afi-safi-adj-rib-in-tlv {
 *     uses afi-safi-gauge-tlv;
 *   }
 *   container per-afi-safi-loc-rib-tlv {
 *     uses afi-safi-gauge-tlv;
 *   }
 *   container updates-treated-as-withdraw-tlv {
 *     uses count-tlv;
 *   }
 *   container prefixes-treated-as-withdraw-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-updates-tlv {
 *     uses count-tlv;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat-tlvs</i>
 *
 */
public interface StatTlvs
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stat-tlvs");

    @Override
    Class<? extends StatTlvs> implementedInterface();
    
    /**
     * Stat Type = 0: (32-bit Counter) Number of prefixes rejected by inbound policy.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlv</code> <code>rejectedPrefixesTlv</code>, or <code>null</code> if not present
     */
    @Nullable RejectedPrefixesTlv getRejectedPrefixesTlv();
    
    /**
     * Stat Type = 1: (32-bit Counter) Number of (known) duplicate prefix
     * advertisements.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlv</code> <code>duplicatePrefixAdvertisementsTlv</code>, or <code>null</code> if not present
     */
    @Nullable DuplicatePrefixAdvertisementsTlv getDuplicatePrefixAdvertisementsTlv();
    
    /**
     * Stat Type = 2: (32-bit Counter) Number of (known) duplicate withdraws.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlv</code> <code>duplicateWithdrawsTlv</code>, or <code>null</code> if not present
     */
    @Nullable DuplicateWithdrawsTlv getDuplicateWithdrawsTlv();
    
    /**
     * Stat Type = 3: (32-bit Counter) Number of updates invalidated due to
     * CLUSTER_LIST loop.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlv</code> <code>invalidatedClusterListLoopTlv</code>, or <code>null</code> if not present
     */
    @Nullable InvalidatedClusterListLoopTlv getInvalidatedClusterListLoopTlv();
    
    /**
     * Stat Type = 4: (32-bit Counter) Number of updates invalidated due to AS_PATH
     * loop.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlv</code> <code>invalidatedAsPathLoopTlv</code>, or <code>null</code> if not present
     */
    @Nullable InvalidatedAsPathLoopTlv getInvalidatedAsPathLoopTlv();
    
    /**
     * Stat Type = 5: (32-bit Counter) Number of updates invalidated due to
     * ORIGINATOR_ID.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlv</code> <code>invalidatedOriginatorIdTlv</code>, or <code>null</code> if not present
     */
    @Nullable InvalidatedOriginatorIdTlv getInvalidatedOriginatorIdTlv();
    
    /**
     * Stat Type = 6: (32-bit Counter) Number of updates invalidated due to AS_CONFED
     * loop.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlv</code> <code>invalidatedAsConfedLoopTlv</code>, or <code>null</code> if not present
     */
    @Nullable InvalidatedAsConfedLoopTlv getInvalidatedAsConfedLoopTlv();
    
    /**
     * Stat Type = 7: (64-bit Gauge) Number of routes in Adj-RIBs-In.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlv</code> <code>adjRibsInRoutesTlv</code>, or <code>null</code> if not present
     */
    @Nullable AdjRibsInRoutesTlv getAdjRibsInRoutesTlv();
    
    /**
     * Stat Type = 8: (64-bit Gauge) Number of routes in Loc-RIB.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlv</code> <code>locRibRoutesTlv</code>, or <code>null</code> if not present
     */
    @Nullable LocRibRoutesTlv getLocRibRoutesTlv();
    
    /**
     * Stat Type = 9: Number of routes in per-AFI/SAFI Adj-RIB-In. The value is
     * structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv</code> <code>perAfiSafiAdjRibInTlv</code>, or <code>null</code> if not present
     */
    @Nullable PerAfiSafiAdjRibInTlv getPerAfiSafiAdjRibInTlv();
    
    /**
     * Stat Type = 10: Number of routes in per-AFI/SAFI Loc-RIB. The value is
     * structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv</code> <code>perAfiSafiLocRibTlv</code>, or <code>null</code> if not present
     */
    @Nullable PerAfiSafiLocRibTlv getPerAfiSafiLocRibTlv();
    
    /**
     * Stat Type = 11: (32-bit Counter) Number of updates subjected to
     * treat-as-withdraw treatment. 
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlv</code> <code>updatesTreatedAsWithdrawTlv</code>, or <code>null</code> if not present
     */
    @Nullable UpdatesTreatedAsWithdrawTlv getUpdatesTreatedAsWithdrawTlv();
    
    /**
     * Stat Type = 12: (32-bit Counter) Number of prefixes subjected to
     * treat-as-withdraw treatment. 
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv</code> <code>prefixesTreatedAsWithdrawTlv</code>, or <code>null</code> if not present
     */
    @Nullable PrefixesTreatedAsWithdrawTlv getPrefixesTreatedAsWithdrawTlv();
    
    /**
     * Stat Type = 13: (32-bit Counter) Number of duplicate update messages received. 
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlv</code> <code>duplicateUpdatesTlv</code>, or <code>null</code> if not present
     */
    @Nullable DuplicateUpdatesTlv getDuplicateUpdatesTlv();

}

