package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * These messages contain information that could be used by the monitoring station 
 * to observe interesting events that occur on the router.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification stats-reports-message {
 *   uses peer-header;
 *   uses stat;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stats-reports-message</i>
 *
 * <p>To create instances of this class use {@link StatsReportsMessageBuilder}.
 * @see StatsReportsMessageBuilder
 *
 */
public interface StatsReportsMessage
    extends
    DataObject,
    Augmentable<StatsReportsMessage>,
    PeerHeader,
    Stat,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stats-reports-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage.class;
    }

}

