package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping string-tlv {
 *   container string-tlv {
 *     uses tlv;
 *     leaf string-info {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/string-tlv</i>
 *
 */
public interface StringTlv
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("string-tlv");

    @Override
    Class<? extends StringTlv> implementedInterface();
    
    /**
     * Type = 0: String. The Information field contains a free-form UTF-8 string whose
     * length is given by the Information Length field. Inclusion of this TLV is
     * optional. Multiple String TLVs MAY be included in the message.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv</code> <code>stringTlv</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.@Nullable StringTlv getStringTlv();

}

