package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The termination message provides a way for a monitored router to indicate why 
 * is terminating a session.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification termination-message {
 *   uses termination;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/termination-message</i>
 *
 * <p>To create instances of this class use {@link TerminationMessageBuilder}.
 * @see TerminationMessageBuilder
 *
 */
public interface TerminationMessage
    extends
    DataObject,
    Augmentable<TerminationMessage>,
    Termination,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("termination-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage.class;
    }

}

