package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The time when the encapsulated routes were received (one may also think of this 
 * as the time when they were installed in the Adj-RIB-In), expressed in seconds 
 * and microseconds since midnight (zero hour), January 1, 1970 (UTC). If zero, 
 * time is unavailable. Precision of the timestamp is implementation- dependent.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping timestamp {
 *   leaf timestamp-sec {
 *     type yang:timestamp;
 *     default 0;
 *   }
 *   leaf timestamp-micro {
 *     type yang:timestamp;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/timestamp</i>
 *
 */
public interface Timestamp
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("timestamp");

    @Override
    Class<? extends Timestamp> implementedInterface();
    
    /**
     * Timestamp with seconds precision.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp</code> <code>timestampSec</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.@Nullable Timestamp getTimestampSec();
    
    /**
     * Timestamp with microseconds precision.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp</code> <code>timestampMicro</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.@Nullable Timestamp getTimestampMicro();

}

