package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Type = 1: sysDescr. The Information field contains an ASCII string whose value 
 * MUST be set to be equal to the value of the sysDescr MIB-II [RFC1213] object. 
 * Inclusion of this TLV is mandatory.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container description-tlv {
 *   uses tlv;
 *   leaf description {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/description-tlv/description-tlv</i>
 *
 * <p>To create instances of this class use {@link DescriptionTlvBuilder}.
 * @see DescriptionTlvBuilder
 *
 */
public interface DescriptionTlv
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv>,
    Augmentable<DescriptionTlv>,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("description-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>description</code>, or <code>null</code> if not present
     */
    @Nullable String getDescription();

}

