package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.initiation;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.NameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TlvsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TlvsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TlvsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TlvsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TlvsBuilder
 * @see Builder
 *
 */
public class TlvsBuilder implements Builder<Tlvs> {

    private DescriptionTlv _descriptionTlv;
    private NameTlv _nameTlv;
    private List<StringInformation> _stringInformation;


    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationTlvs arg) {
        this._stringInformation = arg.getStringInformation();
        this._descriptionTlv = arg.getDescriptionTlv();
        this._nameTlv = arg.getNameTlv();
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations arg) {
        this._stringInformation = arg.getStringInformation();
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv arg) {
        this._descriptionTlv = arg.getDescriptionTlv();
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv arg) {
        this._nameTlv = arg.getNameTlv();
    }

    public TlvsBuilder(Tlvs base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> aug =((AugmentationHolder<Tlvs>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._descriptionTlv = base.getDescriptionTlv();
        this._nameTlv = base.getNameTlv();
        this._stringInformation = base.getStringInformation();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationTlvs</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv) {
            this._nameTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv)arg).getNameTlv();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations) {
            this._stringInformation = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations)arg).getStringInformation();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationTlvs) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv) {
            this._descriptionTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv)arg).getDescriptionTlv();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationTlvs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv]");
    }

    public DescriptionTlv getDescriptionTlv() {
        return _descriptionTlv;
    }
    
    public NameTlv getNameTlv() {
        return _nameTlv;
    }
    
    public List<StringInformation> getStringInformation() {
        return _stringInformation;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tlvs>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public TlvsBuilder setDescriptionTlv(final DescriptionTlv value) {
        this._descriptionTlv = value;
        return this;
    }
    
    public TlvsBuilder setNameTlv(final NameTlv value) {
        this._nameTlv = value;
        return this;
    }
    public TlvsBuilder setStringInformation(final List<StringInformation> values) {
        this._stringInformation = values;
        return this;
    }
    
    
    public TlvsBuilder addAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType, Augmentation<Tlvs> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
        extends AbstractAugmentable<Tlvs>
        implements Tlvs {
    
        private final DescriptionTlv _descriptionTlv;
        private final NameTlv _nameTlv;
        private final List<StringInformation> _stringInformation;
    
        TlvsImpl(TlvsBuilder base) {
            super(base.augmentation);
            this._descriptionTlv = base.getDescriptionTlv();
            this._nameTlv = base.getNameTlv();
            this._stringInformation = base.getStringInformation();
        }
    
        @Override
        public DescriptionTlv getDescriptionTlv() {
            return _descriptionTlv;
        }
        
        @Override
        public NameTlv getNameTlv() {
            return _nameTlv;
        }
        
        @Override
        public List<StringInformation> getStringInformation() {
            return _stringInformation;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_descriptionTlv);
            result = prime * result + Objects.hashCode(_nameTlv);
            result = prime * result + Objects.hashCode(_stringInformation);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Tlvs other = (Tlvs)obj;
            if (!Objects.equals(_descriptionTlv, other.getDescriptionTlv())) {
                return false;
            }
            if (!Objects.equals(_nameTlv, other.getNameTlv())) {
                return false;
            }
            if (!Objects.equals(_stringInformation, other.getStringInformation())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlvsImpl otherImpl = (TlvsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs");
            CodeHelpers.appendValue(helper, "_descriptionTlv", _descriptionTlv);
            CodeHelpers.appendValue(helper, "_nameTlv", _nameTlv);
            CodeHelpers.appendValue(helper, "_stringInformation", _stringInformation);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
