package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * BGP PDU containing the BGP NOTIFICATION message as received from the peer.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container notification {
 *   uses bgp-msg:notify-message;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-down/data/notification/notification</i>
 *
 * <p>To create instances of this class use {@link NotificationBuilder}.
 * @see NotificationBuilder
 *
 */
public interface Notification
    extends
    ChildOf<PeerDown>,
    Augmentable<Notification>,
    NotifyMessage
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification.class;
    }

}

