package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NotificationBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NotificationBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NotificationBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NotificationBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NotificationBuilder
 * @see Builder
 *
 */
public class NotificationBuilder implements Builder<Notification> {

    private byte[] _data;
    private Uint8 _errorCode;
    private Uint8 _errorSubcode;


    Map<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> augmentation = Collections.emptyMap();

    public NotificationBuilder() {
    }
    public NotificationBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage arg) {
        this._errorCode = arg.getErrorCode();
        this._errorSubcode = arg.getErrorSubcode();
        this._data = arg.getData();
    }

    public NotificationBuilder(Notification base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> aug =((AugmentationHolder<Notification>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._data = base.getData();
        this._errorCode = base.getErrorCode();
        this._errorSubcode = base.getErrorSubcode();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage) {
            this._errorCode = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage)arg).getErrorCode();
            this._errorSubcode = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage)arg).getErrorSubcode();
            this._data = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage)arg).getData();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage]");
    }

    public byte[] getData() {
        return _data == null ? null : _data.clone();
    }
    
    public Uint8 getErrorCode() {
        return _errorCode;
    }
    
    public Uint8 getErrorSubcode() {
        return _errorSubcode;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Notification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NotificationBuilder setData(final byte[] value) {
        this._data = value;
        return this;
    }
    
    public NotificationBuilder setErrorCode(final Uint8 value) {
        this._errorCode = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setErrorCode(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NotificationBuilder setErrorCode(final Short value) {
        return setErrorCode(CodeHelpers.compatUint(value));
    }
    
    public NotificationBuilder setErrorSubcode(final Uint8 value) {
        this._errorSubcode = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setErrorSubcode(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NotificationBuilder setErrorSubcode(final Short value) {
        return setErrorSubcode(CodeHelpers.compatUint(value));
    }
    
    public NotificationBuilder addAugmentation(Class<? extends Augmentation<Notification>> augmentationType, Augmentation<Notification> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NotificationBuilder removeAugmentation(Class<? extends Augmentation<Notification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Notification build() {
        return new NotificationImpl(this);
    }

    private static final class NotificationImpl
        extends AbstractAugmentable<Notification>
        implements Notification {
    
        private final byte[] _data;
        private final Uint8 _errorCode;
        private final Uint8 _errorSubcode;
    
        NotificationImpl(NotificationBuilder base) {
            super(base.augmentation);
            this._data = base.getData();
            this._errorCode = base.getErrorCode();
            this._errorSubcode = base.getErrorSubcode();
        }
    
        @Override
        public byte[] getData() {
            return _data == null ? null : _data.clone();
        }
        
        @Override
        public Uint8 getErrorCode() {
            return _errorCode;
        }
        
        @Override
        public Uint8 getErrorSubcode() {
            return _errorSubcode;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Arrays.hashCode(_data);
            result = prime * result + Objects.hashCode(_errorCode);
            result = prime * result + Objects.hashCode(_errorSubcode);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Notification.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Notification other = (Notification)obj;
            if (!Arrays.equals(_data, other.getData())) {
                return false;
            }
            if (!Objects.equals(_errorCode, other.getErrorCode())) {
                return false;
            }
            if (!Objects.equals(_errorSubcode, other.getErrorSubcode())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NotificationImpl otherImpl = (NotificationImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Notification");
            CodeHelpers.appendValue(helper, "_data", _data);
            CodeHelpers.appendValue(helper, "_errorCode", _errorCode);
            CodeHelpers.appendValue(helper, "_errorSubcode", _errorSubcode);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
