package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container peer-header {
 *   uses peer;
 *   uses timestamp;
 *   leaf adj-rib-in-type {
 *     type adj-rib-in-type;
 *   }
 *   leaf ipv4 {
 *     type boolean;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-header/peer-header</i>
 *
 * <p>To create instances of this class use {@link PeerHeaderBuilder}.
 * @see PeerHeaderBuilder
 *
 */
public interface PeerHeader
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader>,
    Augmentable<PeerHeader>,
    Peer,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-header");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType</code> <code>adjRibInType</code>, or <code>null</code> if not present
     */
    @Nullable AdjRibInType getAdjRibInType();
    
    /**
     * Indicates if peer's address is IPv4. If set to false address is IPv6.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>ipv4</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isIpv4();

}

