package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerHeaderBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerHeaderBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerHeaderBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerHeaderBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerHeaderBuilder
 * @see Builder
 *
 */
public class PeerHeaderBuilder implements Builder<PeerHeader> {

    private IpAddressNoZone _address;
    private AdjRibInType _adjRibInType;
    private AsNumber _as;
    private Ipv4AddressNoZone _bgpId;
    private PeerDistinguisher _peerDistinguisher;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;
    private PeerType _type;
    private Boolean _ipv4;


    Map<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> augmentation = Collections.emptyMap();

    public PeerHeaderBuilder() {
    }
    public PeerHeaderBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer arg) {
        this._type = arg.getType();
        this._peerDistinguisher = arg.getPeerDistinguisher();
        this._address = arg.getAddress();
        this._as = arg.getAs();
        this._bgpId = arg.getBgpId();
    }
    public PeerHeaderBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public PeerHeaderBuilder(PeerHeader base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> aug =((AugmentationHolder<PeerHeader>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._address = base.getAddress();
        this._adjRibInType = base.getAdjRibInType();
        this._as = base.getAs();
        this._bgpId = base.getBgpId();
        this._peerDistinguisher = base.getPeerDistinguisher();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
        this._type = base.getType();
        this._ipv4 = base.isIpv4();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer) {
            this._type = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getType();
            this._peerDistinguisher = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getPeerDistinguisher();
            this._address = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getAddress();
            this._as = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getAs();
            this._bgpId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getBgpId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp]");
    }

    public IpAddressNoZone getAddress() {
        return _address;
    }
    
    public AdjRibInType getAdjRibInType() {
        return _adjRibInType;
    }
    
    public AsNumber getAs() {
        return _as;
    }
    
    public Ipv4AddressNoZone getBgpId() {
        return _bgpId;
    }
    
    public PeerDistinguisher getPeerDistinguisher() {
        return _peerDistinguisher;
    }
    
    public Timestamp getTimestampMicro() {
        return _timestampMicro;
    }
    
    public Timestamp getTimestampSec() {
        return _timestampSec;
    }
    
    public PeerType getType() {
        return _type;
    }
    
    public Boolean isIpv4() {
        return _ipv4;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerHeader>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public PeerHeaderBuilder setAddress(final IpAddressNoZone value) {
        this._address = value;
        return this;
    }
    
    public PeerHeaderBuilder setAdjRibInType(final AdjRibInType value) {
        this._adjRibInType = value;
        return this;
    }
    
    public PeerHeaderBuilder setAs(final AsNumber value) {
        this._as = value;
        return this;
    }
    
    public PeerHeaderBuilder setBgpId(final Ipv4AddressNoZone value) {
        this._bgpId = value;
        return this;
    }
    
    public PeerHeaderBuilder setPeerDistinguisher(final PeerDistinguisher value) {
        this._peerDistinguisher = value;
        return this;
    }
    
    public PeerHeaderBuilder setTimestampMicro(final Timestamp value) {
        this._timestampMicro = value;
        return this;
    }
    
    public PeerHeaderBuilder setTimestampSec(final Timestamp value) {
        this._timestampSec = value;
        return this;
    }
    
    public PeerHeaderBuilder setType(final PeerType value) {
        this._type = value;
        return this;
    }
    
    public PeerHeaderBuilder setIpv4(final Boolean value) {
        this._ipv4 = value;
        return this;
    }
    
    public PeerHeaderBuilder addAugmentation(Class<? extends Augmentation<PeerHeader>> augmentationType, Augmentation<PeerHeader> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PeerHeaderBuilder removeAugmentation(Class<? extends Augmentation<PeerHeader>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerHeader build() {
        return new PeerHeaderImpl(this);
    }

    private static final class PeerHeaderImpl
        extends AbstractAugmentable<PeerHeader>
        implements PeerHeader {
    
        private final IpAddressNoZone _address;
        private final AdjRibInType _adjRibInType;
        private final AsNumber _as;
        private final Ipv4AddressNoZone _bgpId;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher _peerDistinguisher;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
        private final PeerType _type;
        private final Boolean _ipv4;
    
        PeerHeaderImpl(PeerHeaderBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._adjRibInType = base.getAdjRibInType();
            this._as = base.getAs();
            this._bgpId = base.getBgpId();
            this._peerDistinguisher = base.getPeerDistinguisher();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
            this._type = base.getType();
            this._ipv4 = base.isIpv4();
        }
    
        @Override
        public IpAddressNoZone getAddress() {
            return _address;
        }
        
        @Override
        public AdjRibInType getAdjRibInType() {
            return _adjRibInType;
        }
        
        @Override
        public AsNumber getAs() {
            return _as;
        }
        
        @Override
        public Ipv4AddressNoZone getBgpId() {
            return _bgpId;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher getPeerDistinguisher() {
            return _peerDistinguisher;
        }
        
        @Override
        public Timestamp getTimestampMicro() {
            return _timestampMicro;
        }
        
        @Override
        public Timestamp getTimestampSec() {
            return _timestampSec;
        }
        
        @Override
        public PeerType getType() {
            return _type;
        }
        
        @Override
        public Boolean isIpv4() {
            return _ipv4;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_address);
            result = prime * result + Objects.hashCode(_adjRibInType);
            result = prime * result + Objects.hashCode(_as);
            result = prime * result + Objects.hashCode(_bgpId);
            result = prime * result + Objects.hashCode(_peerDistinguisher);
            result = prime * result + Objects.hashCode(_timestampMicro);
            result = prime * result + Objects.hashCode(_timestampSec);
            result = prime * result + Objects.hashCode(_type);
            result = prime * result + Objects.hashCode(_ipv4);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerHeader.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PeerHeader other = (PeerHeader)obj;
            if (!Objects.equals(_address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(_adjRibInType, other.getAdjRibInType())) {
                return false;
            }
            if (!Objects.equals(_as, other.getAs())) {
                return false;
            }
            if (!Objects.equals(_bgpId, other.getBgpId())) {
                return false;
            }
            if (!Objects.equals(_peerDistinguisher, other.getPeerDistinguisher())) {
                return false;
            }
            if (!Objects.equals(_timestampMicro, other.getTimestampMicro())) {
                return false;
            }
            if (!Objects.equals(_timestampSec, other.getTimestampSec())) {
                return false;
            }
            if (!Objects.equals(_type, other.getType())) {
                return false;
            }
            if (!Objects.equals(_ipv4, other.isIpv4())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PeerHeaderImpl otherImpl = (PeerHeaderImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerHeader");
            CodeHelpers.appendValue(helper, "_address", _address);
            CodeHelpers.appendValue(helper, "_adjRibInType", _adjRibInType);
            CodeHelpers.appendValue(helper, "_as", _as);
            CodeHelpers.appendValue(helper, "_bgpId", _bgpId);
            CodeHelpers.appendValue(helper, "_peerDistinguisher", _peerDistinguisher);
            CodeHelpers.appendValue(helper, "_timestampMicro", _timestampMicro);
            CodeHelpers.appendValue(helper, "_timestampSec", _timestampSec);
            CodeHelpers.appendValue(helper, "_type", _type);
            CodeHelpers.appendValue(helper, "_ipv4", _ipv4);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
