package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The full OPEN message received by the monitored router from its peer.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container received-open {
 *   uses open-msg;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up/received-open</i>
 *
 * <p>To create instances of this class use {@link ReceivedOpenBuilder}.
 * @see ReceivedOpenBuilder
 *
 */
public interface ReceivedOpen
    extends
    ChildOf<PeerUp>,
    Augmentable<ReceivedOpen>,
    OpenMsg
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("received-open");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen.class;
    }

}

